package de.duehl.swing.ui.tables;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

/**
 * Diese Klasse dient als Hilfe zur sehr viel kompakteren Erstellung von Modellen für Tabellen in
 * Swing.
 *
 * @version 1.01     2017-03-29
 * @author Christian Dühl
 */

public class BasicTableColumnModel extends DefaultTableColumnModel {

    private static final long serialVersionUID = 1L;

    private int colNumber;

    /**
     * Fügt eine Spalte hinzu.
     *
     * @param width
     *            Breite der Spalte.
     * @param header
     *            Überschrift der Spalte.
     */
    public void addWidthColumn(int width, String header) {
        TableColumn column = createTableColumn(width, header);
        addColumn(column);
    }

    /**
     * Fügt eine Spalte hinzu, deren Breite nicht kleiner als angegeben werden kann.
     *
     * @param width
     *            Breite der Spalte, gleichzeitig auch minimale Breite.
     * @param header
     *            Überschrift der Spalte.
     */
    public void addMinWidthColumn(int width, String header) {
        addWidthColumnWithSpecialMinWidth(width, header, width);
    }

    /**
     * Fügt eine Spalte hinzu, deren Breite nicht kleiner als angegeben werden kann.
     *
     * @param width
     *            Breite der Spalte.
     * @param header
     *            Überschrift der Spalte.
     * @param minWidth
     *            Minimale Breite der Spalte.
     */
    public void addWidthColumnWithSpecialMinWidth(int width, String header, int minWidth) {
        TableColumn column = createTableColumn(width, header);
        column.setMinWidth(minWidth);
        addColumn(column);
    }

    /**
     * Fügt eine Spalte hinzu, deren Breite nicht kleiner oder größer als angegeben werden kann.
     *
     * @param width
     *            Breite der Spalte, gleichzeitig auch minimale und maximale Breite.
     * @param header
     *            Überschrift der Spalte.
     */
    public void addMinMaxWidthColumn(int width, String header) {
        addMinWidthColumnWithSpecialMaxWidth(width, header, width);
    }

    /**
     * Fügt eine Spalte hinzu, deren Breite nicht kleiner oder größer als angegeben werden kann.
     *
     * @param width
     *            Breite der Spalte, gleichzeitig auch minimale Breite.
     * @param header
     *            Überschrift der Spalte.
     * @param maxWidth
     *            Maximale Breite der Spalte.
     */
    public void addMinWidthColumnWithSpecialMaxWidth(int width, String header, int maxWidth) {
        TableColumn column = createTableColumn(width, header);
        column.setMinWidth(width);
        column.setMaxWidth(maxWidth);
        addColumn(column);
    }

    /**
     * Fügt eine Spalte hinzu, deren Breite nicht größer als angegeben werden kann.
     *
     * @param width
     *            Breite der Spalte, gleichzeitig auch maximale Breite.
     * @param header
     *            Überschrift der Spalte.
     */
    public void addMaxWidthColumn(int width, String header) {
        TableColumn column = createTableColumn(width, header);
        column.setMaxWidth(width);
        addColumn(column);
    }

    private TableColumn createTableColumn(int width, String header) {
        TableColumn column = new TableColumn(colNumber++, width);
        column.setHeaderValue(header);
        return column;
    }

}
