package de.duehl.swing.ui.tabs.bars.editors;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.tabs.bars.generic.GrowingTabBar;
import de.duehl.swing.ui.tabs.bars.generic.TabBar;

/**
 * Diese Klasse stellt ein wachsendes Reiterelement dar, welches eine Reihe von Editoren aufnimmt.
 * Dabei wird in jeden Reiter oben ein eigenes Tabulator-Objekt eingefügt, das anzeigen kann,
 * ob der Inhalt des Reiters geändert wurde oder unverändert ist.
 *
 * @version 1.01     2017-12-07
 * @author Christian Dühl
 */
public class GrowingTabBarWithEditors extends TabBarWithEditorsBase {

    private static final int DEFAULT_FONT_SIZE = 20;

    private String basePath;

    private final List<HighlightingEditor> editors;

    /** Konstruktor für Reiter mit Schalter zum Schließen. */
    public GrowingTabBarWithEditors() {
        this(true);
    }

    /**
     * Konstruktor.
     *
     * @param showCloseButton
     *            Gibt an, ob der Button zum Löschen angezeigt werden soll.
     */
    public GrowingTabBarWithEditors(boolean showCloseButton) {
        setShowCloseButton(showCloseButton);
        setTabBar(createTabBar(showCloseButton));
        createAndAddChangeListener();

        basePath = "c:";
        editors = new ArrayList<>();
    }

    private TabBar<Component> createTabBar(boolean showCloseButton) {
        return new GrowingTabBar<Component>(showCloseButton, title -> createNewTab(title));
    }

    private void createNewTab(String title) {
        TabBar<Component> tabBar = getTabBar();
        String notUsedTitle = tabBar.generateNotUsedTitle(title);

        HighlightingEditor editor = createEditor(notUsedTitle);
        addTab(editor);
        editors.add(editor);
    }

    private HighlightingEditor createEditor(String barename) {
        HighlightingEditor editor = new HighlightingEditor();
        editor.useMonospaceFont();
        editor.setFontSize(DEFAULT_FONT_SIZE);
        //editor.useSyntaxHighlighting(generateSyntaxHighlighting());
        String newFilename = FileHelper.concatPathes(basePath, barename);
        editor.setFilenameButDoNotDoAnythingElse(newFilename);
        return editor;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        for (HighlightingEditor editor : editors) {
            String filename = editor.getFilename();
            String barename = FileHelper.getBareName(filename);
            String newFilename = FileHelper.concatPathes(basePath, barename);
            editor.setFilenameButDoNotDoAnythingElse(newFilename);
        }
    }

}
