package de.duehl.swing.ui.tabs.close;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, das auf das Schließen eines Reiters reagiert.
 *
 * @version 1.01     2017-11-14
 * @author Christian Dühl
 */

public interface CloseButtonReaktor {

    /**
     * Reagiert auf das Schließen eines Reiters zu einem Gespräch mit einem anderen Benutzer.
     *
     * @param tabUserOrGroupIdentifier
     *            Login des Benutzers oder ID der Gruppe, zu dem bzw. der der Reiter gehört.
     */
    void closeButtonPressed(String tabUserOrGroupIdentifier);

}
