package de.duehl.swing.ui.tabs.logic;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;

public class EditorAndFilename {

    private final HighlightingEditor editor;
    private String filename;
    private final String barename;

    public EditorAndFilename(HighlightingEditor editor, String filename) {
        this(editor, filename, FileHelper.getBareName(filename));
    }

    public EditorAndFilename(HighlightingEditor editor, String filename, String barename) {
        this.editor = editor;
        this.filename = filename;
        this.barename = barename;
    }

    public HighlightingEditor getEditor() {
        return editor;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBarename() {
        return barename;
    }

    @Override
    public String toString() {
        return "EditorAndFilename [filename=" + filename + ", barename=" + barename + "]";
    }

}
