package de.duehl.swing.ui.text;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

import de.duehl.swing.ui.colors.Colorizer;

/**
 * Dieses Interface stellt die Schnittstelle für Text-anzeigende Komponenten dar.
 *
 * Es erfüllt hauptsächlich den Zweck, dass diese Komponenten die gleichen Methoden für die
 * gleichen Dinge verwenden.
 *
 * @version 1.01     2020-02-12
 * @author Christian Dühl
 */

public interface TextualComponent {

    /** Setzt den anzuzeigenden Text. */
    void setText(String textContents);

    /** Setzt die Position des Cursors. */
    void setCaretPosition(int position);

    /** Gibt die Länge des Textes zurück. */
    int getTextLength();

    /** Zeichnet den Editor neu. */
    void repaint();

    /** Setzt die gewünschte Größe des Text-Elements. */
    void setPreferredSize(int width, int height);

    /** Färbt die übergebene Komponente ein, falls ein Colorizer übergeben wurde. */
    void setColors(Colorizer colorizer);

    /** Gibt die in die Oberfläche einzubauende Komponente zurück. */
    Component getComponent();

}
