package de.duehl.swing.text.caculations;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.swing.text.calculations.MinToMaxSizeCalculator;

public class MinToMaxSizeCalculatorTest {

    @Test (expected = RuntimeException.class)
    public void checkLegalValuesFailCMaxLessThanCMin() {
        double compareMinimum = 100.0d;
        double compareMaximum = 0.0d;
        double compareActual = 50.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
    }

    @Test (expected = RuntimeException.class)
    public void checkLegalValuesFailCActLessThanCMin() {
        double compareMinimum = 50.0d;
        double compareMaximum = 100.0d;
        double compareActual = 0.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
    }

    @Test (expected = RuntimeException.class)
    public void checkLegalValuesFailCActMoreThanCMax() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 120.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
    }

    @Test (expected = RuntimeException.class)
    public void checkLegalValuesFailMMaxLessThanMMin() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 50.0d;
        double wantedMinimum = 100.0d;
        double wantedMaximum = 0.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
    }

    @Test
    public void zeroBased0PercentToZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 0.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 0.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased25PercentToZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 25.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 25.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased50PercentToZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 50.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 50.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased75PercentToZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 75.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 75.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased100PercentToZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 100.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased0PercentToBiggerZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 0.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 0.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased25PercentToBiggerZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 25.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 50.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased50PercentToBiggerZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 50.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 100.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased75PercentToBiggerZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 75.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 150.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased100PercentToBiggerZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 200.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased0PercentToNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 0.0d;
        double wantedMinimum = 100.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 100.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased25PercentToNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 25.0d;
        double wantedMinimum = 100.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 125.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased50PercentToNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 50.0d;
        double wantedMinimum = 100.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 150.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased75PercentToNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 75.0d;
        double wantedMinimum = 100.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 175.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased100PercentToNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 100.0d;
        double wantedMaximum = 200.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 200.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased0PercentToBiggerNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 0.0d;
        double wantedMinimum = 1000.0d;
        double wantedMaximum = 2000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 1000.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased25PercentToBiggerNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 25.0d;
        double wantedMinimum = 1000.0d;
        double wantedMaximum = 2000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 1250.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased50PercentToBiggerNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 50.0d;
        double wantedMinimum = 1000.0d;
        double wantedMaximum = 2000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 1500.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased75PercentToBiggerNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 75.0d;
        double wantedMinimum = 1000.0d;
        double wantedMaximum = 2000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 1750.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void zeroBased100PercentToBiggerNonZeroBased() {
        double compareMinimum = 0.0d;
        double compareMaximum = 100.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 1000.0d;
        double wantedMaximum = 2000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 2000.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased0PercentToZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 0.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased25PercentToZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 125.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 25.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased50PercentToZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 150.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 50.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased75PercentToZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 175.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 75.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased100PercentToZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 200.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 100.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 100.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased0PercentToBiggerZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 1000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 0.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased25PercentToBiggerZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 125.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 1000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 250.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);

    }

    @Test
    public void nonZeroBased50PercentToBiggerZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 150.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 1000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 500.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased75PercentToBiggerZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 175.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 1000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 750.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased100PercentToBiggerZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 200.0d;
        double wantedMinimum = 0.0d;
        double wantedMaximum = 1000.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 1000.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased0PercentToNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 400.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 300.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased25PercentToNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 125.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 400.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 325.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased50PercentToNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 150.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 400.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 350.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased75PercentToNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 175.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 400.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 375.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased100PercentToNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 200.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 400.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 400.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased0PercentToBiggerNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 100.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 500.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 300.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased25PercentToBiggerNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 125.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 500.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 350.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased50PercentToBiggerNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 150.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 500.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 400.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased75PercentToBiggerNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 175.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 500.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 450.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased100PercentToBiggerNonZeroBased() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 200.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 500.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 500.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void krumm1() {
        double compareMinimum = 15.3d;
        double compareMaximum = 77.13d;
        double compareActual = 33.98d;
        double wantedMinimum = 118.0d;
        double wantedMaximum = 421.1d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 209.57218178877565d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

    @Test
    public void nonZeroBased75PercentToBiggerNonZeroBasedIntegers() {
        int compareMinimum = 100;
        int compareMaximum = 200;
        int compareActual = 175;
        int wantedMinimum = 300;
        int wantedMaximum = 500;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculate();
        int actualWantedActual = calculator.getWantedActualAsInt();
        int expectedWantedActual = 450;
        assertEquals(expectedWantedActual, actualWantedActual);
    }

    @Test
    public void nonZeroBased75PercentToBiggerNonZeroBasedIntegersFromMaximum() {
        int compareMinimum = 100;
        int compareMaximum = 200;
        int compareActual = 175;
        int wantedMinimum = 300;
        int wantedMaximum = 500;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculatePercentFromMaximumInsteadOfMinimum();
        calculator.calculate();
        int actualWantedActual = calculator.getWantedActualAsInt();
        int expectedWantedActual = 350;
        assertEquals(expectedWantedActual, actualWantedActual);
    }

    @Test
    public void nonZeroBased75PercentToBiggerNonZeroBasedFromMaximum() {
        double compareMinimum = 100.0d;
        double compareMaximum = 200.0d;
        double compareActual = 175.0d;
        double wantedMinimum = 300.0d;
        double wantedMaximum = 500.0d;
        MinToMaxSizeCalculator calculator = new MinToMaxSizeCalculator(
                compareMinimum, compareMaximum, compareActual,
                wantedMinimum, wantedMaximum);
        calculator.calculatePercentFromMaximumInsteadOfMinimum();
        calculator.calculate();
        double actualWantedActual = calculator.getWantedActual();
        double expectedWantedActual = 350.0d;
        assertEquals(expectedWantedActual, actualWantedActual, 0.001d);
    }

}
