package de.duehl.swing.ui.error;

import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;

public class GuiExceptionHandlerTestWithCallable {

    private static final String MESSAGE = "Abbruch durch den Benutzer!";

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();

        GuiExceptionHandlerRegistration registration = new GuiExceptionHandlerRegistration();
        registration.setAfterErrorHandlingCallable(createCallable());
        registration.addNoDialogErrorMessage(MESSAGE);
        registration.registerToEdt();

        SwingUtilities.invokeLater(() ->
            {
                throw new IllegalArgumentException(MESSAGE);
            }
            );
    }

    private static AfterErrorHandlingCallable createCallable() {
        return new AfterErrorHandlingCallable() {

            @Override
            public void callMeAfterHandledUiError() {
                System.out.println("Ausgabe danach!");
            }

        };
    }

}
