package de.duehl.swing.ui.start;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;

import javax.swing.JComponent;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.pictures.PictureHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.elements.navigator.NavigatorPanelWithDocumentPosition;
import de.duehl.swing.ui.elements.navigator.ReactOnUserElementNumberSelection;
import de.duehl.swing.ui.elements.pictures.PicturePanel;

public class PicturePanelDirTest extends NonModalFrameDialogBase
        implements ReactOnUserElementNumberSelection {

    private static final String TITLE = "PicturePanel-Test";

    private static final Dimension DIALOG_DIMENSION = new Dimension(600, 400);


    private final PicturePanel picturePanel;
    private final NavigatorPanelWithDocumentPosition navigator;

    private final List<String> pictureFilenames;

    private int shownPictureIndex;

    public PicturePanelDirTest(String directory) {
        super(TITLE, DIALOG_DIMENSION);

        pictureFilenames = PictureHelper.determinePicturesInDirectory(directory);

        picturePanel = new PicturePanel();
        picturePanel.setBackground(Color.DARK_GRAY);
        //picturePanel.setAllowBiggerPicture(false);

        navigator = new NavigatorPanelWithDocumentPosition(createErrorHandler());
        shownPictureIndex = -1;

        fillDialog();
    }

    @Override
    protected void populateDialog() {
        add(createNavigatorPart(), BorderLayout.NORTH);
        add(picturePanel, BorderLayout.CENTER);

        showFirstPicture();
    }

    private Component createNavigatorPart() {
        navigator.fillNavigator();
        navigator.addFirstActionListener(e -> first());
        navigator.addPreviousActionListener(e -> previous());
        navigator.addNextActionListener(e -> next());
        navigator.addLastActionListener(e -> last());

        navigator.setReactOnUserElementNumberSelection(this);
        navigator.setTotalNumberOfElements(pictureFilenames.size());

        JComponent centeredNavigation = navigator.center();
        GuiTools.createTitle(centeredNavigation);
        return centeredNavigation;
    }

    private void first() {
        if (shownPictureIndex != 0) {
            shownPictureIndex = 0;
            showPictureAtIndex();
        }
    }

    private void previous() {
        if (shownPictureIndex > 0) {
            --shownPictureIndex ;
            showPictureAtIndex();
        }
    }

    private void next() {
        if (shownPictureIndex < pictureFilenames.size() - 1) {
            ++shownPictureIndex ;
            showPictureAtIndex();
        }
    }

    private void last() {
        if (shownPictureIndex != pictureFilenames.size() - 1) {
            shownPictureIndex = pictureFilenames.size() - 1;
            showPictureAtIndex();
        }
    }

    private void showPictureAtIndex() {
        String pictureFilename = pictureFilenames.get(shownPictureIndex);
        picturePanel.loadPicture(pictureFilename);
        setTitle(TITLE + " - " + FileHelper.getBareName(pictureFilename));
    }

    private void showFirstPicture() {
        first();
    }

    @Override
    public void reactOnUserElementNumberSelection(int elementNumber) {
        shownPictureIndex = elementNumber - 1;
        showPictureAtIndex();
    }

    public static void main(String[] args) {
        String directory = "r:/USR_HR/DokusNatascha/HuPwiki/BilderFuerAllgemVertrBefugnisse/"
                + "hochgeladen";
        new PicturePanelDirTest(directory).setVisible(true);
    }

}
