package de.duehl.swing.ui.start;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.SelectionVerificationDialog;

public class SelectionVerificationDialogTest {

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();

        List<String> things = createThings();
        Point parentLocation = new Point(300, 150);

        SelectionVerificationDialog dialog = new SelectionVerificationDialog(things, parentLocation,
                "Test test test...");
        dialog.setVisible(true);

        if (dialog.userPressedOk()) {
            List<String> selectedThings = dialog.getSelectedThings();
            System.out.println("Auswahl: " + selectedThings);
        }
        else {
            System.out.println("Abbruch durch den Benutzer.");
        }
    }

    private static List<String> createThings() {
        boolean shortList = false;
        if (shortList) {
            return  CollectionsHelper.buildListFrom("Äpfel", "Dübel", "Töpfe", "Straße");
        }
        else {
            return createLongListOfThings();

        }
    }

    private static List<String> createLongListOfThings() {
        List<String> things = new ArrayList<>();

        for (int i = 0; i < 1000; ++i) {
            String thing = "Eintrag " + NumberString.taupu(i + 1);
            //String thing = "Eintrag drei Spalten " + NumberString.taupu(i + 1);
            //String thing = "Langer Eintrag für zwei Spalten " + NumberString.taupu(i + 1);
            //String thing = "Sehr Lange Eintrag für nur eine Spalte " + NumberString.taupu(i + 1);
            things.add(thing);
        }

        return things;
    }

}
