package de.duehl.swing.ui.start.card.a.input;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.layout.card.CardGui;
import de.duehl.swing.ui.layout.card.CardLogic;
import de.duehl.swing.ui.layout.card.CardResult;

public class InputCardLogic extends CardLogic {

    private InputCardResult result;

    @Override
    public void setGui(CardGui gui) {
        if (gui instanceof InputCardGui) {
            // Diese Logik benötigt keinen Zugriff auf die grafische Oberfläche.
            //this.gui = (InputCardGui) gui;
        }
        else {
            throw new RuntimeException("Aufruf mit der falschen Gui!");
        }
    }

    @Override
    public void setResultFromPreviousCard(CardResult previousResult) {
        // Hier muss nichts gemacht werden, da es die erste Karte ist.
        // Die Methode wird auch gar nicht aufgerufen:
        throw new RuntimeException("Darf nicht aufgerufen werden.");
    }

    @Override
    public void runWhenShown() {
        // Hier muss nichts gemacht werden, da es die erste Karte ist.
        // Die Methode wird auch gar nicht aufgerufen:
        throw new RuntimeException("Darf nicht aufgerufen werden.");
    }

    public boolean calculateResult(String value) {
        if (value.matches("\\d+")) {
            int enteredValue = Integer.parseInt(value);
            result = new InputCardResult(enteredValue);
            return true;
        }
        else {
            return false;
        }
    }

    @Override
    public CardResult getResult() {
        return result;
    }

    @Override
    public void quit() {
        // Hier muss nichts gemacht werden, weil es keinen
        // laufenden anderen Thread zur Berechnung gibt.
    }

}
