package de.duehl.swing.ui.start.card.b.work;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JPanel;

import de.duehl.swing.ui.layout.card.CardGui;
import de.duehl.swing.ui.layout.card.CardLogic;
import de.duehl.swing.ui.layout.card.CardSwitcher;

public class WorkCardGui implements CardGui {

    private CardSwitcher switcher;

    @Override
    public void setLogic(CardLogic logic) {
        if (logic instanceof WorkCardLogic) {
            // Diese Gui braucht keinen Zugriff auf die Logik.
            // this.logic = (WorkCardLogic) logic;
        }
        else {
            throw new RuntimeException("Aufruf mit der falschen Logik!");
        }
    }

    @Override
    public Component createGui(CardSwitcher switcher) {
        this.switcher = switcher;

        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createTitleLabel(), BorderLayout.CENTER);

        return panel;
    }

    private Component createTitleLabel() {
        JLabel label = new JLabel("Berechnung des Ergebnisses ...");
        label.setForeground(Color.BLUE);
        label.setHorizontalAlignment(JLabel.CENTER);
        return label;
    }

    public void done() {
        switcher.switchCard();
    }

    @Override
    public void cleanUp() {
        // Hier muss nichts aufgeräumt werden...
    }

}
