package de.duehl.swing.ui.start.filter.project;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.start.filter.project.data.TestFilterData;

public class DemoLinesCreater {

    public static List<TestFilterData> createDemoDatasets() {
        List<TestFilterData> datasets = new ArrayList<>();

        datasets.add(new TestFilterData("123001", "04.11.2020",
                CollectionsHelper.buildListFrom("bla bla", "bla bla bla"),
                "Test-Firma Eins GmbH", "4711"));
        datasets.add(new TestFilterData("123002", "04.11.2020",
                CollectionsHelper.buildListFrom("bla bla", "bla bla bla"),
                "Test-Firma Zwei GmbH", "4711", "4712"));
        datasets.add(new TestFilterData("123003", "04.11.2020",
                CollectionsHelper.buildListFrom("bla bla", "bla bla bla"),
                "Test-Firma Drei GmbH", "4711", "4713", "4714"));
        datasets.add(new TestFilterData("123003", "04.11.2020",
                CollectionsHelper.buildListFrom("bla bla bla bla bla"),
                "Test-Firma Vier GmbH", "4711", "4713", "4714"));

        return datasets;
    };

}
