package de.duehl.swing.ui.start.progress;

import java.awt.Point;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.progress.ProgressDialog;

public class ProgressDialogDemo {

    private static final int NUMBER_OF_TASKS = 20;
    private static final Random RANDOM = new Random();

    private List<String> taskDescriptions;

    private final ProgressDialog progressDialog;

    public ProgressDialogDemo() {
        GuiTools.setNiceLayoutManager();

        progressDialog = new ProgressDialog("Fortschritt bei der Bearbeitung von Demo-Aufgaben",
                new Point(300, 200), null)
                .setProgressTitle("Fortschritt beim Ausführen von Demo-Aufgaben:")
                .setCountPrefix("Anzahl ausgeführter Aufgaben: ")
                .setTimerPrefix("Laufzeit: ")
                .setActualElementPrefix("Führe aus: ")
                .setActualElementPrefixBeforeStart("Noch nichts ausgeführt.")
                .setActualElementWhenDone("Alle Demo-Aufgaben wurden ausgeführt.")
                .createProgressPanel();
    }

    public void run() {
        createTaskDescriptions();
        progressDialog.initNumberOfTasksToDo(taskDescriptions.size());

        new Thread(() -> runTasksInOwnThread()).start();
        progressDialog.createUi();
    }

    private void createTaskDescriptions() {
        taskDescriptions = new ArrayList<>();
        for (int number = 1; number <= NUMBER_OF_TASKS; ++number) {
            taskDescriptions.add("Aufgabe " + number);
        }
    }

    private void runTasksInOwnThread() {
        SystemTools.sleep(250); // damit der Dialog Zeit hat, sich aufzubauen bevor es auch schon
                                // los geht.

        progressDialog.startingWithTask();

        for (String taskDescription : taskDescriptions) {
            runTask(taskDescription);
        }

        progressDialog.closeUi();
    }

    private void runTask(String taskDescription) {
        progressDialog.aboutToExceuteOneTaskSoon(taskDescription);

        int sleepSeconds = 1 + RANDOM.nextInt(3);
        SystemTools.sleepSeconds(sleepSeconds);

        progressDialog.oneTaskDone(taskDescription);
    }

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        ProgressDialogDemo demo = new ProgressDialogDemo();
        demo.run();
    }

}
