package de.duehl.swing.ui.start.tabbars;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.tabs.bars.growing.GrowingTabbedPane;

public class GrowingTabbedPaneTest {

    private final JFrame frame;
    private final JTabbedPane tabs;

    public GrowingTabbedPaneTest() {
        GuiTools.setNiceLayoutManager();

        frame = new JFrame("Growing Tabbed Pane Test");
        tabs = new GrowingTabbedPane(title -> createNewTab(title));

        frame.add(tabs);
        frame.setSize(new Dimension(400, 200));
    }

    protected void createNewTab(String title) {
        JLabel component = new JLabel(title);
        tabs.addTab(title, component);
    }

    public void setVisible(boolean visible) {
        frame.setVisible(visible);
    }

    public static void main(String[] args) {
        new GrowingTabbedPaneTest().setVisible(true);
    }

}
