package de.duehl.swing.ui.start.tabbars;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.tabs.bars.generic.TabBar;

/**
 * Diese Klasse testet die TabBar-Elemente.
 *
 * @version 1.01     2017-11-21
 * @author Christian Dühl
 */

public class TabBarTestWhithoutCloseButtons {

    /** Die zu testenden Reiter. */
    private TabBar<JPanel> tabBar;

    /** Konstruktor. */
    public TabBarTestWhithoutCloseButtons() {
        boolean showCloseButton = false;
        tabBar = new TabBar<>(showCloseButton);
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("TabBar Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        frame.add(createTabBar());

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createTabBar() {
        addTab("Äpfel" , Color.GREEN);
        addTab("Birnen" , Color.RED);
        addTab("Pflaumen" , Color.BLUE);

        return tabBar.getComponent();
    }

    private void addTab(String title, Color color) {
        JPanel panel = createPanel(title, color);
        tabBar.addTab(title, panel);
    }

    private JPanel createPanel(String title, Color color) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(color);

        panel.add(createRemoveButton(title, color), BorderLayout.CENTER);

        return panel;
    }

    private Component createRemoveButton(String title,  Color color) {
        JButton button = new JButton(title);
        button.setForeground(color);
        button.addActionListener(e -> buttonPressed(title));
        return button;
    }

    private void buttonPressed(String title) {
        tabBar.removeTab(title);
        tabBar.validate();
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new TabBarTestWhithoutCloseButtons();
    }

}

