package de.duehl.swing.ui.start.timedate;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.data.MinuteHour;
import de.duehl.swing.ui.components.selections.datetime.QuarterlyTimeSelection;
import de.duehl.swing.ui.components.selections.datetime.TimeSelection;
import de.duehl.swing.ui.components.selections.datetime.WeekdaySelection;

public class AllSelectionsTest {

    private final TimeSelection timeSelection = new TimeSelection();
    private final QuarterlyTimeSelection quarterlyTimeSelection = new QuarterlyTimeSelection();
    private final WeekdaySelection weekdaySelection = new WeekdaySelection();

    public AllSelectionsTest() {
        timeSelection.setTime(new MinuteHour("13:37"));
        quarterlyTimeSelection.setTime(new MinuteHour("12:15"));
                                              // Falls 12:17 -> IllegalArgumentException
                                              //                "invalid sequence element"
        weekdaySelection.setText("Donnerstag");
        SwingUtilities.invokeLater(this::createFrame);
    }

    private void createFrame() {
        JFrame frame= new JFrame();
        frame.setTitle("Kombiniertes Testprogramm");

        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(createSelectionspart(), BorderLayout.CENTER);
        frame.add(createPrintButton(), BorderLayout.SOUTH);

        frame.pack();
        frame.setVisible(true);
    }

    private Component createSelectionspart() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 2, 2, 2));

        panel.add(new JLabel("Wochentag:"));
        panel.add(weekdaySelection.getPanel());
        panel.add(new JLabel("Zeit:"));
        panel.add(timeSelection.getPanel());
        panel.add(new JLabel("Viertelstündliche Zeit:"));
        panel.add(quarterlyTimeSelection.getPanel());

        return panel;
    }

    private Component createPrintButton() {
        JButton button = new JButton("Print");
        button.addActionListener(e -> print());
        return button;
    }

    private void print() {
        String weekday = weekdaySelection.getText();
        String time = timeSelection.getTime().toString();
        String quarterlyTime = quarterlyTimeSelection.getTime().toString();
        System.out.println("Wochentag: " + weekday + ", Zeit: " + time
                + ", Viertelstündliche Zeit: " + quarterlyTime);
    }

    public static void main(String[] args) {
        new AllSelectionsTest();
    }

}
