package de.duehl.swing.ui.start.update;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.update.UpdateGui;

public class UpdateTestGui extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(750, 350);

    private final UpdateTestLogic logic;

    private final UpdateGui updateGui;

    public UpdateTestGui(UpdateTestLogic logic) {
        super("Was-ist-da-Tool", DIALOG_DIMENSION);
        addClosingWindowListener(logic);
        addEscapeBehaviour();

        this.logic = logic;

        updateGui = new UpdateGui(this);
        logic.createUpdateLogic(updateGui);

        fillDialog();
    }

    /** Füllt den Rahmen des Dialoges. */
    @Override
    protected void populateDialog() {
        add(updateGui.createUpdateGridPanel(), BorderLayout.NORTH);
        add(createMainPart(), BorderLayout.CENTER);
        add(createButtonPart(), BorderLayout.SOUTH);
    }

    private Component createMainPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        // TODO Auto-generated method stub

        return panel;
    }

    private Component createButtonPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createQuitButton(), BorderLayout.WEST);
        panel.add(updateGui.createUpdateButtons(), BorderLayout.EAST);

        return panel;
    }

    private Component createQuitButton() {
        JButton button = new JButton("Beenden");
        button.addActionListener(e -> logic.quit());
        return button;
    }

    public void quit() {
        closeDialog();
    }

    public void updateNow() {
        SwingUtilities.invokeLater(() -> updateGui.pressActualizeButton());
    }

}
