package de.duehl.swing.ui.start.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JFrame;
import javax.swing.SwingConstants;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.watch.CountDownWatchLabel;

public class CountDownWatchLabelTest {

    public static void main(String[] args) {
        JFrame frame = new JFrame("CountDownWatchLabel Demo");
        frame.setLayout(new BorderLayout());

        String startText = "<html><center>Stoppuhr"
        + "<br/>"
        + "Countdown"
        + "<br/>";
        String endText = "</center></html>";
        long duration = 60;

        CountDownWatchLabel label = new CountDownWatchLabel(duration, startText, endText);
        label.setHorizontalAlignment(SwingConstants.CENTER);
        label.setForeground(Color.RED);
        GuiTools.biggerFont(label, 5);
        frame.add(label, BorderLayout.CENTER);

        frame.setSize(400, 120);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
    }

}
