package de.duehl.threads;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

public class WaitingRunnable extends ATimableRunnable implements Runnable {

    public WaitingRunnable(final int seconds) {
        super(seconds);
    }

    @Override
    protected void tryToRun() throws InterruptedException {
        Thread.sleep(1000 * seconds);
    }

}
