package de.duehl.twosidecommander.try1.element.displayer;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JLabel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;

import static de.duehl.twosidecommander.ui.color.ListCommanderColors.*;

public class DemoListElementDisplayer extends ListElementDisplayer {

    private final String text;

    private JLabel label;

    public DemoListElementDisplayer(ListElementMoveReactor listElementMoveReactor, String text) {
        super(listElementMoveReactor);

        this.text = text;

        setListElementShowDetailsName("Details anzeigen");
        initLabel();
        createGui();
    }

    private void initLabel() {
        label = new JLabel(text);
        GuiTools.biggerFont(label, 15);
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3)); // top left bottom right
    }

    @Override
    protected Component createElementDisplay() {
        return label;
    }

    @Override
    public void showSelectedAndHighlighted() {
        label.setForeground(SELECTED_LABEL_FOREGROUND_COLOR);
        label.setBackground(HIGHLIGHTED_LABEL_BACKGROUND_COLOR);
    }

    @Override
    public void showSelected() {
        label.setForeground(SELECTED_LABEL_FOREGROUND_COLOR);
    }

    @Override
    public void showHighlighted() {
        label.setBackground(HIGHLIGHTED_LABEL_BACKGROUND_COLOR);
    }

    @Override
    public void showNormal() {
        label.setBackground(NORMAL_LABEL_BACKGROUND_COLOR);
    }

    @Override
    public String getElementDescription() {
        return "Beispiel-Element-Beschreibung des Elements " + text;
    }

    /** Im Rechtsklick-Menü des Listenelements wurde die Ansicht der Details ausgewählt. */
    @Override
    protected final void reactOnShowDetailsClickInRightClickMenu() {
        System.out.println("Rechtklick-Menü Details wurde ausgewählt. Element: " + text);
    }

    public final static DemoListElementDisplayer castListElementDisplayer(
            ListElementDisplayer listElementDisplayer) {
        return (DemoListElementDisplayer) listElementDisplayer;
    }

    public String getText() {
        return text;
    }

    @Override
    public String toString() {
        return "DemoListElementDisplayer [text=" + text + "]";
    }

}
