package de.duehl.vocabulary.japanese.common.data;

/**
 * Diese Enum-Klasse stellt eine Art dar, wie Vokabeln einer Liste zum Abfragen sortiert werden.
 *
 * @version 1.01     2023-10-20
 * @author Christian Dühl
 */

public enum VocablesShuffleType {

    NATURAL("unverändert"),
    ALPHABETICAL("alphabetisch"),
    RANDOM("zufällig"),
    LAST_CORRECT_TEST_DATE("basierend auf dem Zeitpunkt der letzten richtigen Antwort"),
    FIRST_SEEN_DATE("basierend auf dem Zeitpunkt des ursprünglichen Hinzufügens"),
    LAST_ANSWERS_SUCCESS("basierend auf dem Erfolg bei den letzten Abfragen"),
    MIX("basierend auf einem Mix aus den Zeitpunkten und dem Erfolg bei den letzten Abfragen"),
    ;

    /** Die Beschreibung der Auswahl für Optionen-Dialog. */
    private final String description;

    /**
     * Konstruktor.
     *
     * @param description
     *            Die Beschreibung der Auswahl für Optionen-Dialog.
     */
    private VocablesShuffleType(String description) {
        this.description = description;
    }

    /** Getter für die Beschreibung der Auswahl für Optionen-Dialog. */
    public String getDescription() {
        return description;
    }

    /** Ermittelt den Typ über den Namen. */
    public static VocablesShuffleType determineByName(String vocabularySelectionTypeName) {
        for (VocablesShuffleType selectionType : VocablesShuffleType.values()) {
            String name = selectionType.name();
            if (name.equals(vocabularySelectionTypeName)) {
                return selectionType;
            }
        }

        throw new RuntimeException("Zum Namen '" + vocabularySelectionTypeName
                + "' konnte keine Sortierreihenfolge ermittelt werden.");
    }

}
