package de.duehl.vocabulary.japanese.common.data;

/**
 * Diese Enum-Klasse stellt eine Art dar, wie Vokabeln für eine zufällige Teilmenge ausgewählt
 * werden.
 *
 * @version 1.01     2023-10-21
 * @author Christian Dühl
 */

public enum VocablesSubsetSelectionType {

    PURE_RANDOM("rein zufällig"),
    RANDOM_AND_LAST_ANSWER_SUCCESS(
            "zufällig, aber beeinflusst vom Erfolg bei den letzten Abfragen"),
    RANDOM_AND_FIRST_SEEN_DATE(
            "zufällig, aber beeinflusst vom Zeitpunkt des ursprünglichen Hinzufügens"),
    RANDOM_AND_LAST_CORRECT_TEST_DATE(
            "zufällig, aber beeinflusst vom Zeitpunkt der letzten richtigen Antwort"),
    RANDOM_AND_MIX(
            "zufällig, aber beeinflusst vom Mix aus den Zeitpunkten und dem Erfolg bei den "
                    + "letzten Abfragen"),
    ;

    /** Die Beschreibung der Auswahl für Optionen-Dialog. */
    private final String description;

    /**
     * Konstruktor.
     *
     * @param description
     *            Die Beschreibung der Auswahl für Optionen-Dialog.
     */
    private VocablesSubsetSelectionType(String description) {
        this.description = description;
    }

    /** Getter für die Beschreibung der Auswahl für Optionen-Dialog. */
    public String getDescription() {
        return description;
    }

    /** Ermittelt den Typ über den Namen. */
    public static VocablesSubsetSelectionType determineByName(
            String vocabularyeRandomSubsetSelectionTypeName) {
        for (VocablesSubsetSelectionType randomSubsetSelectionType :
            VocablesSubsetSelectionType.values()) {
            String name = randomSubsetSelectionType.name();
            if (name.equals(vocabularyeRandomSubsetSelectionTypeName)) {
                return randomSubsetSelectionType;
            }
        }

        throw new RuntimeException("Zum Namen '" + vocabularyeRandomSubsetSelectionTypeName
                + "' konnte keine Aer der zufälligen Auswahl einer Teilmenge ermittelt werden.");
    }

}
