package de.duehl.vocabulary.japanese.common.website.update.vocables;

/**
 * Diese Klasse erstellt Dateinamen für die Archive mit den Vokabularien.
 *
 * @version 1.01     2024-11-26
 * @author Christian Dühl
 */

public class VocabularyZipFilenameCreator {

    /** Erzeugt den Dateinamen des Archivs mit den Vokabularien mit Aussprache mit Pfad. */
    public static String createZipBareFilenameWithMp3(String version) {
        return version + "_vocables_full.zip";
    }

    /** Erzeugt den Dateinamen des Archivs mit den Vokabularien mit Aussprache ohne Pfad. */
    public static String createZipBareFilenameWithoutMp3(String version) {
        return version + "_vocables_pure.zip";
    }

}
