package de.duehl.vocabulary.japanese.io;

import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.data.KanjiSet;

/**
 * Diese Klasse gibt einer (Teil-) Menge von Kanji, die der Benutzer definiert hat, einen anderen
 * Dateinamen.
 *
 * @version 1.01     2024-11-21
 * @author Christian Dühl
 */

public class KanjiSetFileRenamer {

    /**
     * Beim Umbenennen einer Kanji-Menge sollte man auch die zugehörige Datei umbenennen, das
     * passiert hier.
     */
    public static void renameListFile(String oldName, String newName) {
        String oldFilename = KanjiSet.determineFilename(oldName);
        String newFilename = KanjiSet.determineFilename(newName);

        /*
         * Falls man direkt schon beim Anlegen einer Kanji-Menge diese umbenennt, fehlt die Datei
         * noch. Daher wird hier geprüft, ob sie vorhanden ist:
         */
        if (FileHelper.exists(oldFilename)) {
            FileHelper.moveFile(oldFilename, newFilename);
        }
    }

}
