package de.duehl.vocabulary.japanese.logic.symbol.kana.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.data.KanaStructure;

/**
 * Diese Klasse erzeugt HTML-Code mit einer Übersicht über die Katakana.
 *
 * @version 1.01     2024-10-02
 * @author Christian Dühl
 */

public class KatakanaHtmlCreator {

    /** Die Struktur mit den Katakana-Zeichen. */
    private KanaStructure structure;

    /** Der erzeugte HTML-Code. */
    private String html;

    /** Erzeugt den HTML-Code. */
    public void create() {
        createStructure();
        createKanaHtml();
    }

    private void createStructure() {
        structure = new KanaStructure();

        structure.fillAIUEO(
                Katakana.A.toKana(),
                Katakana.I.toKana(),
                Katakana.U.toKana(),
                Katakana.E.toKana(),
                Katakana.O.toKana());
        structure.fillKaKiKuKeKo(
                Katakana.KA.toKana(),
                Katakana.KI.toKana(),
                Katakana.KU.toKana(),
                Katakana.KE.toKana(),
                Katakana.KO.toKana());
        structure.fillSaShiSuSeSo(
                Katakana.SA.toKana(),
                Katakana.SHI.toKana(),
                Katakana.SU.toKana(),
                Katakana.SE.toKana(),
                Katakana.SO.toKana());
        structure.fillTaChiTsuTeTo(
                Katakana.TA.toKana(),
                Katakana.CHI.toKana(),
                Katakana.TSU.toKana(),
                Katakana.TE.toKana(),
                Katakana.TO.toKana());
        structure.fillNaNiNuNeNo(
                Katakana.NA.toKana(),
                Katakana.NI.toKana(),
                Katakana.NU.toKana(),
                Katakana.NE.toKana(),
                Katakana.NO.toKana());
        structure.fillHaHiFuHeHo(
                Katakana.HA.toKana(),
                Katakana.HI.toKana(),
                Katakana.FU.toKana(),
                Katakana.HE.toKana(),
                Katakana.HO.toKana());
        structure.fillMaMiMuMeMo(
                Katakana.MA.toKana(),
                Katakana.MI.toKana(),
                Katakana.MU.toKana(),
                Katakana.ME.toKana(),
                Katakana.MO.toKana());
        structure.fillYaYuYo(
                Katakana.YA.toKana(),
                Katakana.YU.toKana(),
                Katakana.YO.toKana());
        structure.fillRaRiRuReRo(
                Katakana.RA.toKana(),
                Katakana.RI.toKana(),
                Katakana.RU.toKana(),
                Katakana.RE.toKana(),
                Katakana.RO.toKana());
        structure.fillWaWo(
                Katakana.WA.toKana(),
                Katakana.WO.toKana());
        structure.fillN(
                Katakana.N.toKana());
        structure.fillGaGiGuGeGo(
                Katakana.GA.toKana(),
                Katakana.GI.toKana(),
                Katakana.GU.toKana(),
                Katakana.GE.toKana(),
                Katakana.GO.toKana());
        structure.fillZaJiZuZeZo(
                Katakana.ZA.toKana(),
                Katakana.JI1.toKana(),
                Katakana.ZU1.toKana(),
                Katakana.ZE.toKana(),
                Katakana.ZO.toKana());
        structure.fillDaJiZuDeDo(
                Katakana.DA.toKana(),
                Katakana.JI2.toKana(),
                Katakana.ZU2.toKana(),
                Katakana.DE.toKana(),
                Katakana.DO.toKana());
        structure.fillBaBiBuBeBo(
                Katakana.BA.toKana(),
                Katakana.BI.toKana(),
                Katakana.BU.toKana(),
                Katakana.BE.toKana(),
                Katakana.BO.toKana());
        structure.fillPaPiPuPePo(
                Katakana.PA.toKana(),
                Katakana.PI.toKana(),
                Katakana.PU.toKana(),
                Katakana.PE.toKana(),
                Katakana.PO.toKana());

        structure.fillKyaKyuKyo(
                Katakana.KYA.toKana(),
                Katakana.KYU.toKana(),
                Katakana.KYO.toKana());
        structure.fillShaShuSho(
                Katakana.SHA.toKana(),
                Katakana.SHU.toKana(),
                Katakana.SHO.toKana());
        structure.fillChaChuCho(
                Katakana.CHA.toKana(),
                Katakana.CHU.toKana(),
                Katakana.CHO.toKana());
        structure.fillNyaNyuNyo(
                Katakana.NYA.toKana(),
                Katakana.NYU.toKana(),
                Katakana.NYO.toKana());
        structure.fillHyaHyuHyo(
                Katakana.HYA.toKana(),
                Katakana.HYU.toKana(),
                Katakana.HYO.toKana());
        structure.fillMyaMyuMyo(
                Katakana.MYA.toKana(),
                Katakana.MYU.toKana(),
                Katakana.MYO.toKana());
        structure.fillRyaRyuRyo(
                Katakana.RYA.toKana(),
                Katakana.RYU.toKana(),
                Katakana.RYO.toKana());
        structure.fillGyaGyuGyo(
                Katakana.GYA.toKana(),
                Katakana.GYU.toKana(),
                Katakana.GYO.toKana());
        structure.fillJaJuJo1(
                Katakana.JA1.toKana(),
                Katakana.JU1.toKana(),
                Katakana.JO1.toKana());
        structure.fillJaJuJo2(
                Katakana.JA2.toKana(),
                Katakana.JU2.toKana(),
                Katakana.JO2.toKana());
        structure.fillByaByuByo(
                Katakana.BYA.toKana(),
                Katakana.BYU.toKana(),
                Katakana.BYO.toKana());
        structure.fillPyaPyuPyo(
                Katakana.PYA.toKana(),
                Katakana.PYU.toKana(),
                Katakana.PYO.toKana());

        structure.fillKanaLehnworte(CollectionsHelper.buildListFrom(
                Katakana.LEHNWORT_F1.toKana(),
                Katakana.LEHNWORT_F2.toKana(),
                Katakana.LEHNWORT_F3.toKana(),
                Katakana.LEHNWORT_F4.toKana(),
                Katakana.LEHNWORT_W1.toKana(),
                Katakana.LEHNWORT_W2.toKana(),
                Katakana.LEHNWORT_W3.toKana(),
                Katakana.LEHNWORT_W4.toKana(),
                Katakana.LEHNWORT_W5.toKana(),
                Katakana.LEHNWORT_TI.toKana(),
                Katakana.LEHNWORT_DI.toKana(),
                Katakana.LEHNWORT_TU.toKana(),
                Katakana.LEHNWORT_DU.toKana()
                ));

        structure.fillKleinesTsu(Katakana.SMALL_TSU.toKana());
        structure.fillKleinesYaYuYoGo(
                Katakana.SMALL_YA.toKana(),
                Katakana.SMALL_YU.toKana(),
                Katakana.SMALL_YO.toKana()
                );
    }

    private void createKanaHtml() {
        KanaHtmlCreator creator = new KanaHtmlCreator(structure, "Katakana");
        creator.create();
        html = creator.getHtml();
    }

    /** Getter für den erzeugten HTML-Code. */
    public String getHtml() {
        return html;
    }

}
