package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt der die Deutsch-Japanischen Übersetzungen NICHT erzeugt.
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public class Step08BSkipCreateGermanToJapaneseTranslation extends StartupStep {

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     */
    public Step08BSkipCreateGermanToJapaneseTranslation(String step, Options options,
            SplashScreenable splashScreen, StopWatch watch) {
        super(step, options, splashScreen, watch);
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Die Datenstrukturen für mehrdeutige Übersetzungen von Deutsch in "
                + "Japanisch werden noch nicht erzeugt, sondern erst bei der ersten "
                + "Verwendung.");
    }

}
