package de.duehl.vocabulary.japanese.startup.ui.data;

/**
 * Dieses Interface enthält die für die Schritte benötigten Methoden des SplashScreens, damit diese
 * auch unabhängig vom Startup zu anderen Zwecken verwendet werden können.
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public interface SplashScreenable extends MessageAppender {

    /** Teilt mit, dass ein Schritt gestartet wird. */
    void startStep(String step);

    /** Teilt mit, dass ein Schritt erfolgreich beendet wurde. */
    void stepGood(String step);

    /** Teilt mit, dass ein Schritt mit Warnungen beendet wurde. */
    void stepWarning(String step);

    /** Teilt mit, dass ein Schritt mit Fehlern beendet wurde. */
    void stepError(String step);

}
