package de.duehl.vocabulary.japanese.ui.dialog.kanji.detail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.KanjiPanel;

/**
 * Diese Klasse zeigt die Details eines Kanji inklusive der internen Daten des Benutzers an.
 *
 * @version 1.01     2025-11-21
 * @author Christian Dühl
 */

public class KanjiDetailDialog extends ModalDialogBase {

    private static final int MIN_WIDTH = 700;


    /** Das UI-Komponente, auf der die Daten des Kanji dargestellt werden. */
    private final KanjiPanel kanjiPanel;

    /** Der Button zum Beenden. */
    private final JButton okButton;

    /**
     * Konstruktor.
     *
     * @param kanji
     *            Das anzuzeigende Kanji.
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects
     *            Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     * @param informer
     *            Die Oberfläche, welche diese Klasse aufruft, auf der man eine GlassPane anzeigen
     *            kann.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     */
    public KanjiDetailDialog(Kanji kanji, FumikoDataStructures dataStructures,
            FumikoUiObjects uiObjects, LongTimeProcessInformer informer, Point parentLocation) {
        super(parentLocation, uiObjects.getProgramImage(), "Details des zu " + kanji.getCharacter());
        addEscapeBehaviour();

        kanjiPanel = new KanjiPanel(kanji, getWindowAsComponent());
        kanjiPanel.showKanjiAsViewerToo();
        kanjiPanel.showInternalKanjiDataToo(dataStructures);
        kanjiPanel.showButtonsToo(dataStructures, uiObjects, getLocation(), informer);
        kanjiPanel.createGui();
        kanjiPanel.showKanji();

        okButton = new JButton("Beenden");

        init();
        fillDialog();
    }

    private void init() {
        okButton.addActionListener(e -> closeDialog());
    }

    @Override
    protected void populateDialog() {
        add(createDummyWidthLabel(), BorderLayout.NORTH);
        add(createCenterPart(), BorderLayout.CENTER);
        add(createButtonsPart(),  BorderLayout.SOUTH);

        SwingUtilities.invokeLater(() -> okButton.requestFocus());
    }

    private Component createDummyWidthLabel() {
        JLabel label = new JLabel("");
        label.setPreferredSize(new Dimension(MIN_WIDTH, 0));
        return label;
    }

    private Component createCenterPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
        GuiTools.createTitle(panel);

        panel.add(kanjiPanel.getPanel());

        return panel;
    }

    private Component createButtonsPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(okButton, BorderLayout.EAST);

        return panel;
    }

}
