package de.duehl.vocabulary.japanese.data.symbol;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

import java.util.List;

public class KatakanaTest {

    @Test
    public void getAllKatakanaAsString() {
        List<String> katakana = Katakana.getAllKatakanaAsStringList();
        assertEquals(124, katakana.size());
        assertEquals(Katakana.A.getCharacter(), katakana.get(0));
        assertEquals(Katakana.SMALL_TSU.getCharacter(), katakana.get(123));
    }

    @Test
    public void containsKatakana() {
        String text = "Löwe = ライオン (raion)";
        assertTrue(Katakana.containsKatakana(text));
    }

    @Test
    public void containsOnlyKatakanaSuccess() {
        String text = "ライオン";
        assertTrue(Katakana.containsOnlyKatakana(text));
    }

    @Test
    public void containsOnlyKatakanaFail() {
        String text = "Löwe = ライオン (raion)";
        assertFalse(Katakana.containsOnlyKatakana(text));
    }

    @Test
    public void containsOnlyKatakanaEmptyText() {
        String text = "";
        assertFalse(Katakana.containsOnlyKatakana(text));
    }

    @Test
    public void firstIndexOfKatakana() {
        String text = "Löwe = ライオン (raion)";
        int actual = Katakana.firstIndexOfKatakana(text);
        int expected = 7;
        assertEquals(expected, actual);

        int raIndex = text.indexOf("ラ");
        assertEquals(expected, raIndex);
    }

    @Test
    public void firstIndexOfKatakanaEmptyText() {
        String text = "";
        int actual = Katakana.firstIndexOfKatakana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

    @Test
    public void firstIndexOfKatakanaNoKatakanaInText() {
        String text = "Hmmm";
        int actual = Katakana.firstIndexOfKatakana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

    @Test
    public void lastIndexOfKatakana() {
        String text = "Löwe = ライオン (raion)";
        int actual = Katakana.lastIndexOfKatakana(text);
        int expected = 10;
        assertEquals(expected, actual);

        int nIndex = text.indexOf("ン");
        assertEquals(expected, nIndex);
    }

    @Test
    public void lastIndexOfKatakanaEmptyText() {
        String text = "";
        int actual = Katakana.lastIndexOfKatakana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

    @Test
    public void lastIndexOfKatakanaNoKatakanaInText() {
        String text = "Hmmm";
        int actual = Katakana.lastIndexOfKatakana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

}
