/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.autodetect.ent;

import de.duehl.basics.autodetect.ent.AutoCommentAppender;
import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EntWorker
extends AutoCommentAppender {
    public static final List<String> SEPARATORS = CollectionsHelper.buildListFrom(",", ".", "|", "<", ">", "(", ")", "[", "]", "{", "}", ":", ";");
    protected String ent;

    public EntWorker(String string) {
        this.ent = string;
    }

    public final String getEnt() {
        return this.ent;
    }

    public void setEnt(String string) {
        this.ent = string;
    }

    protected final boolean entMatches(Pattern pattern) {
        return EntWorker.entMatches(this.ent, pattern);
    }

    public static final boolean entMatches(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    protected boolean isNotDetectedPartEmpty() {
        return EntWorker.isNotDetectedPartEmpty(this.ent);
    }

    public static boolean isNotDetectedPartEmpty(String string) {
        String string2 = EntWorker.determineNotDetectedPart(string);
        return string2.isEmpty();
    }

    protected boolean isNotDetectedPartEmptyOrUnd() {
        return EntWorker.isNotDetectedPartEmptyOrUnd(this.ent);
    }

    public static boolean isNotDetectedPartEmptyOrUnd(String string) {
        String string2 = EntWorker.determineNotDetectedPart(string);
        return string2.isEmpty() || "und".equals(string2) || ".".equals(string2) && string.endsWith(".");
    }

    protected boolean isNotDetectedPartEmptyOrUndOrAmp() {
        return EntWorker.isNotDetectedPartEmptyOrUndOrAmp(this.ent);
    }

    public static boolean isNotDetectedPartEmptyOrUndOrAmp(String string) {
        String string2 = EntWorker.determineNotDetectedPart(string);
        return string2.isEmpty() || "und".equals(string2) || "&".equals(string2) || ".".equals(string2) && string.endsWith(".");
    }

    protected boolean isNotDetectedPartSubstantive() {
        return EntWorker.isNotDetectedPartSubstantive(this.ent);
    }

    public static boolean isNotDetectedPartSubstantive(String string) {
        String string2 = EntWorker.determineNotDetectedPart(string);
        return Text.isSubstantive(string2);
    }

    protected String determineNotDetectedPart() {
        return EntWorker.determineNotDetectedPart(this.ent);
    }

    public static final String determineNotDetectedPart(String string) {
        String string2 = string;
        string2 = string2.replaceAll(">>.$", ">>");
        string2 = string2.replaceAll("<<[^>]+>>", " ");
        for (String string3 : SEPARATORS) {
            string2 = string2.replace(string3, " ");
        }
        string2 = string2.replace("-", " ");
        string2 = Text.stripWhitespace(string2);
        return string2;
    }

    protected List<String> buildFoundStructure(List<String> list) {
        return EntWorker.buildFoundStructure(this.ent, list);
    }

    public static List<String> buildFoundStructure(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        boolean bl = true;
        while (bl) {
            int n2 = string.indexOf("<<", n);
            if (n2 == -1) {
                bl = false;
                continue;
            }
            n = n2 + 2;
            String string2 = string.substring(n);
            for (String string3 : list) {
                if (!string2.startsWith(string3 + ":")) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    protected List<Integer> buildFoundPlaceholderIndicesList(List<String> list) {
        return EntWorker.buildFoundPlaceholderIndicesList(this.ent, list);
    }

    public static final List<Integer> buildFoundPlaceholderIndicesList(String string, List<String> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        boolean bl = true;
        while (bl) {
            int n2 = string.indexOf("<<", n);
            if (n2 == -1) {
                bl = false;
                continue;
            }
            n = n2 + 2;
            String string2 = string.substring(n);
            for (String string3 : list) {
                int n3;
                if (!string2.startsWith(string3 + ":") || !(string2 = string2.substring(string3.length())).startsWith(":") || (n3 = NumberString.findNaturalNumberAtStart(string2 = string2.substring(1))) <= -1) continue;
                arrayList.add(n3);
            }
        }
        return arrayList;
    }

    public static final int countInFoundStructure(List<String> list, String string) {
        int n = 0;
        for (String string2 : list) {
            if (!string.equals(string2)) continue;
            ++n;
        }
        return n;
    }

    public static final int determineFirstIndexInFoundStructure(List<String> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }
}

