/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.caller;

public class NiceStackTraceElement {
    private final StackTraceElement element;

    public NiceStackTraceElement(StackTraceElement stackTraceElement) {
        this.element = stackTraceElement;
    }

    public String getClassName() {
        return this.element.getClassName();
    }

    public Class<?> getClassObject() {
        try {
            return Class.forName(this.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public String getFileName() {
        return this.element.getFileName();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getMethodName() {
        return this.element.getMethodName();
    }

    public String getModuleName() {
        return this.element.getModuleName();
    }

    public String getModuleVersion() {
        return this.element.getModuleVersion();
    }

    public String toString() {
        return this.getClassName() + "#" + this.getMethodName() + "() - " + this.getLineNumber();
    }

    public String toStringWithAll() {
        return "Klasse: " + this.getClassName() + ", Methode: " + this.getMethodName() + ", Zeile: " + this.getLineNumber() + ", Datei: " + this.getFileName() + ", Modul: " + this.getModuleName() + ", Modul-Version: " + this.getModuleVersion() + ", Datei: " + this.getFileName();
    }
}

