/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.collections;

import de.duehl.basics.exceptions.EmptyQueueException;
import java.util.ArrayList;
import java.util.List;

public class Queue<E> {
    private final List<E> queueElements = new ArrayList();

    public boolean isEmpty() {
        return this.queueElements.isEmpty();
    }

    public boolean hasElements() {
        return !this.isEmpty();
    }

    public void clear() {
        this.queueElements.clear();
    }

    public void queue(E e) {
        this.queueElements.add(e);
    }

    public E take() {
        if (this.isEmpty()) {
            throw new EmptyQueueException("Die Warteschlange ist leer!");
        }
        return this.queueElements.remove(0);
    }

    public int size() {
        return this.queueElements.size();
    }

    public List<E> getElementsAsList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        arrayList.addAll(this.queueElements);
        return arrayList;
    }

    public void takeAllElementsFrom(Queue<E> queue) {
        while (queue.hasElements()) {
            this.queue(queue.take());
        }
    }

    public String toString() {
        return "Queue [queueElements=" + this.queueElements + "]";
    }
}

