/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date.parse;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.date.parse.DateParseMethod;
import de.duehl.basics.datetime.date.parse.DateParseMethodMinus;
import de.duehl.basics.datetime.date.parse.DateParseMethodMonthWordsBlanks;
import de.duehl.basics.datetime.date.parse.DateParseMethodMonthWordsBlanksShortYear;
import de.duehl.basics.datetime.date.parse.DateParseMethodMonthWordsHyphens;
import de.duehl.basics.datetime.date.parse.DateParseMethodMonthWordsHyphensShortYear;
import de.duehl.basics.datetime.date.parse.DateParseMethodNormal;
import de.duehl.basics.datetime.date.parse.DateParseMethodSlash;
import de.duehl.basics.datetime.date.parse.DateParseMethodTwoDigitYear;
import de.duehl.basics.datetime.date.parse.DateParseMethodUnix;
import de.duehl.basics.datetime.date.parse.DateParseMethodYYYYMMDD;
import java.util.ArrayList;
import java.util.List;

public class DateParser {
    private final List<DateParseMethod> methods;
    private final String dateToParse;

    public DateParser(String string) {
        this.dateToParse = string;
        this.methods = this.createDateParseMethodsList();
    }

    private List<DateParseMethod> createDateParseMethodsList() {
        ArrayList<DateParseMethod> arrayList = new ArrayList<DateParseMethod>();
        arrayList.add(new DateParseMethodNormal(this.dateToParse));
        arrayList.add(new DateParseMethodUnix(this.dateToParse));
        arrayList.add(new DateParseMethodTwoDigitYear(this.dateToParse));
        arrayList.add(new DateParseMethodYYYYMMDD(this.dateToParse));
        arrayList.add(new DateParseMethodSlash(this.dateToParse));
        arrayList.add(new DateParseMethodMinus(this.dateToParse));
        arrayList.add(new DateParseMethodMonthWordsBlanks(this.dateToParse));
        arrayList.add(new DateParseMethodMonthWordsBlanksShortYear(this.dateToParse));
        arrayList.add(new DateParseMethodMonthWordsHyphens(this.dateToParse));
        arrayList.add(new DateParseMethodMonthWordsHyphensShortYear(this.dateToParse));
        return arrayList;
    }

    public ImmutualDate parse() {
        for (DateParseMethod dateParseMethod : this.methods) {
            dateParseMethod.parse();
            if (!dateParseMethod.isSuccessfull()) continue;
            return dateParseMethod.getParsedDate();
        }
        return new ImmutualDate(0, 0, 0);
    }
}

