/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.lock;

import de.duehl.basics.io.lock.Lock;
import de.duehl.basics.io.lock.ThrowingFileLock;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.retry.Retry;
import de.duehl.basics.retry.Retryable;

public class RetryingThrowingFileLock
implements Lock {
    private final String lockfile;
    private final int maximumNumberOfTries;
    private final long millisecondsToSleep;
    private final Lock lock;
    private final Logger logger;
    private boolean randomizeSleepTime;

    public RetryingThrowingFileLock(String string, int n, long l) {
        this(string, n, l, null);
    }

    public RetryingThrowingFileLock(String string, int n, long l, Logger logger) {
        this.lockfile = string;
        this.maximumNumberOfTries = n;
        this.millisecondsToSleep = l;
        this.logger = logger;
        this.lock = new ThrowingFileLock(string);
        this.log("locke auf " + this.lock.getFilename());
        this.randomizeSleepTime = false;
    }

    public void randomizeSleepTime() {
        this.randomizeSleepTime = true;
    }

    @Override
    public boolean lock() {
        Retry retry = this.createRetry();
        retry.tryAndTry();
        boolean bl = retry.isSucessfullyDone();
        this.log("lock bekommen? Erfolg: " + bl);
        return bl;
    }

    private Retry createRetry() {
        Retryable retryable = this.createGetLockRetryable();
        Retry retry = new Retry(retryable, this.maximumNumberOfTries, this.millisecondsToSleep, this.logger);
        if (this.randomizeSleepTime) {
            retry.randomizeSleepTime();
        }
        return retry;
    }

    private Retryable createGetLockRetryable() {
        return new Retryable(){

            @Override
            public void tryIt() {
                RetryingThrowingFileLock.this.lock.lock();
            }
        };
    }

    @Override
    public boolean unlock() {
        boolean bl = this.lock.unlock();
        this.log("lock gel\u00f6st? Erfolg: " + bl);
        return bl;
    }

    @Override
    public String getFilename() {
        return this.lockfile;
    }

    private void log(String string) {
        if (this.logger != null) {
            this.logger.log(string, 1);
        }
    }
}

