/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile;

import de.duehl.basics.io.textfile.StringsFromTextFileReader;
import de.duehl.basics.io.textfile.data.Definition;
import de.duehl.basics.io.textfile.data.Definitions;
import de.duehl.basics.text.Text;
import java.util.List;

public class DefinitionsFromTextFileReader {
    private static final String SEPARATING_REGEX = " *[=:] *";
    private final StringsFromTextFileReader reader;

    public DefinitionsFromTextFileReader(StringsFromTextFileReader stringsFromTextFileReader) {
        this.reader = stringsFromTextFileReader;
        stringsFromTextFileReader.doNotTrimLines();
    }

    public void beQuiet() {
        this.reader.beQuiet();
    }

    public void changeToLowerCase() {
        this.reader.changeToLowerCase();
    }

    public Definitions read() {
        Definitions definitions = new Definitions();
        for (String string : this.reader.read()) {
            List<String> list = Text.splitBy(string, SEPARATING_REGEX);
            if (list.size() != 2) {
                throw new IllegalArgumentException("Zeile '" + string + "' l\u00e4sst sich nicht an ':' oder '=' in zwei Teile teilen..");
            }
            String string2 = list.get(0);
            String string3 = list.get(1);
            Definition definition = new Definition(string2, string3);
            definitions.add(definition);
        }
        return definitions;
    }
}

