/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.regex;

import de.duehl.basics.text.NumberString;

public class RangeToRegex {
    private static boolean BRACKETS = true;
    private static final String OPENING_BRACKET = BRACKETS ? "(?:" : "";
    private static final String OPENING_BRACKET_WITHOUT_QUESTIONMARK = BRACKETS ? "(" : "";
    private static final String CLOSING_BRACKET = BRACKETS ? ")" : "";
    private final int from;
    private final int to;
    private StringBuilder regex;
    private String openingBracket;
    private String closingBracket;

    public RangeToRegex(String string, String string2) {
        this(NumberString.parseInt(string, "Die untere Grenze '" + string + "' des Bereiches l\u00e4sst sich nicht als Integer parsen."), NumberString.parseInt(string2, "Die obere Grenze '" + string2 + "' des Bereiches l\u00e4sst sich nicht als Integer parsen."));
    }

    public RangeToRegex(int n, int n2) {
        this.from = n;
        this.to = n2;
        if (n < 0) {
            throw new IllegalArgumentException("Die untere Grenze '" + n + "' des Bereiches ist kleiner als 0.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Die obere Grenze '" + n2 + "' des Bereiches ist kleiner als 0.");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Die obere Grenze '" + n2 + "' ist kleiner als die untere Grenze '" + n + "' des Bereiches .");
        }
        this.openingBracket = OPENING_BRACKET;
        this.closingBracket = CLOSING_BRACKET;
    }

    public void useNormalBreaks() {
        this.openingBracket = OPENING_BRACKET_WITHOUT_QUESTIONMARK;
        this.closingBracket = CLOSING_BRACKET;
    }

    public String createRegexFullMatch() {
        this.regex = new StringBuilder();
        this.regex.append("^");
        this.createRegexInnerMatch(this.regex);
        this.regex.append("$");
        return this.regex.toString();
    }

    public String createRegexWholeWordMatch() {
        this.regex = new StringBuilder();
        this.regex.append("(?:^|\\b)");
        this.createRegexInnerMatch(this.regex);
        this.regex.append("(?:$|\\b)");
        return this.regex.toString();
    }

    public String createRegexPartMatch() {
        this.regex = new StringBuilder();
        this.createRegexInnerMatch(this.regex);
        return this.regex.toString();
    }

    private void createRegexInnerMatch(StringBuilder stringBuilder) {
        stringBuilder.append(this.openingBracket);
        this.createRangeRegex();
        stringBuilder.append(this.closingBracket);
    }

    private void createRangeRegexSimple() {
        boolean bl = true;
        for (int i = this.from; i <= this.to; ++i) {
            if (bl) {
                bl = false;
            } else {
                this.regex.append("|");
            }
            this.regex.append(i);
        }
    }

    private void createRangeRegex() {
        this.regex.append(this.rangeRegex(this.from, this.to));
    }

    String rangeRegex(int n, int n2) {
        return this.rangeRegex("" + n, "" + n2);
    }

    String rangeRegex(String string, String string2) {
        return string.length() == string2.length() ? this.eqLengths(string, string2) : this.nonEqLengths(string, string2);
    }

    private String eqLengths(String string, String string2) {
        char c = string.charAt(0);
        char c2 = string2.charAt(0);
        if (string.length() == 1 && string2.length() == 1) {
            return this.charClass(c, c2);
        }
        if (c == c2) {
            return c + this.openingBracket + this.rangeRegex(string.substring(1), string2.substring(1)) + this.closingBracket;
        }
        String string3 = c + this.openingBracket + this.baseRange(string.substring(1), true, false) + this.closingBracket + "|" + c2 + this.openingBracket + this.baseRange(string2.substring(1), false, false) + this.closingBracket;
        if ((c = (char)(c + '\u0001')) <= (c2 = (char)(c2 - '\u0001'))) {
            string3 = string3 + "|" + this.charClass(c, c2) + this.nDigits(string.length() - 1);
        }
        return string3;
    }

    private String nonEqLengths(String string, String string2) {
        String string3 = this.baseRange(string, true, false) + "|" + this.baseRange(string2, false, true);
        if (string2.length() - string.length() > 1) {
            string3 = string3 + "|[1-9]" + this.nDigits(string.length(), string2.length() - 2);
        }
        return string3;
    }

    private String baseRange(String string, boolean bl, boolean bl2) {
        char c;
        char c2 = string.charAt(0);
        char c3 = bl ? c2 : (bl2 ? (char)'1' : '0');
        char c4 = c = bl ? (char)'9' : c2;
        if (string.length() == 1) {
            return this.charClass(c3, c);
        }
        String string2 = c2 + this.openingBracket + this.baseRange(string.substring(1), bl, false) + this.closingBracket;
        if (bl) {
            c3 = (char)(c3 + '\u0001');
        } else {
            c = (char)(c - '\u0001');
        }
        if (c3 <= c) {
            string2 = string2 + "|" + this.charClass(c3, c) + this.nDigits(string.length() - 1);
        }
        return string2;
    }

    private String charClass(char c, char c2) {
        return String.format(c == c2 ? "%c" : (c2 - c > 1 ? "[%c-%c]" : "[%c%c]"), Character.valueOf(c), Character.valueOf(c2));
    }

    private String nDigits(int n) {
        return this.nDigits(n, n);
    }

    private String nDigits(int n, int n2) {
        return "[0-9]" + String.format(n == n2 ? (n == 1 ? "" : "{%d}") : "{%d,%d}", n, n2);
    }
}

