/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class WhereAreWeOld {
    private WhereAreWeOld() {
    }

    public static boolean areWeAtWork() {
        return WhereAreWeOld.whereAreWe() == Place.AT_WORK;
    }

    public static boolean areWeAtHome() {
        return WhereAreWeOld.whereAreWe() == Place.AT_HOME;
    }

    private static Place whereAreWe() {
        InetAddress inetAddress = WhereAreWeOld.getIpAddress();
        if (null == inetAddress) {
            return Place.NOWHERE;
        }
        String string = inetAddress.getHostAddress();
        if (string.startsWith("192.168.30.")) {
            return Place.AT_WORK;
        }
        return Place.AT_HOME;
    }

    private static InetAddress getIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static enum Place {
        AT_WORK,
        AT_HOME,
        NOWHERE;

    }
}

