/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.test;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.textfile.FullNormalTextFileReader;
import de.duehl.basics.io.textfile.FullTextFileReader;
import de.duehl.basics.test.FindJavaTestFileOnLocalHardDrive;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public abstract class FindMethodCallsInTestFiles {
    private static final List<String> ALLOWED_LINE_ENDINGS = CollectionsHelper.buildListFrom(");", ",", "); // H\u00e4ndisch ge\u00e4ndert");
    private static final List<String> ALLOWED_LINE_ENDINGS_STAND_ALONE = CollectionsHelper.buildListFrom(",");
    public static final String JAVA_END = ".java";
    private final List<String> testClassNames;
    private final List<String> testMethods;
    private final List<String> informations;
    private boolean lastLineContainedOpeningTestMethodWithoutQuotedString;
    private final FindJavaTestFileOnLocalHardDrive finder;

    public FindMethodCallsInTestFiles(List<String> list, List<String> list2, FindJavaTestFileOnLocalHardDrive findJavaTestFileOnLocalHardDrive) {
        this.testClassNames = list;
        this.testMethods = list2;
        this.finder = findJavaTestFileOnLocalHardDrive;
        this.informations = new ArrayList<String>();
        this.lastLineContainedOpeningTestMethodWithoutQuotedString = false;
        this.readMethodCallsFromFiles();
    }

    private void readMethodCallsFromFiles() {
        for (String string2 : this.testClassNames) {
            FullTextFileReader fullTextFileReader = this.createReader(string2);
            fullTextFileReader.beQuiet();
            fullTextFileReader.read(string -> this.analyseLine(string));
        }
    }

    private FullTextFileReader createReader(String string) {
        String string2 = this.finder.findJavaTestFile(string + JAVA_END);
        return new FullNormalTextFileReader(string2, Charset.UTF_8);
    }

    private void analyseLine(String string) {
        String string2 = string.trim();
        this.analyseCleanedLine(string2);
    }

    private void analyseCleanedLine(String string) {
        if (this.lastLineContainedOpeningTestMethodWithoutQuotedString) {
            this.extractInformationFrom(this.removeAllowedLineEndingsForStandAlone(string));
            this.lastLineContainedOpeningTestMethodWithoutQuotedString = false;
        } else {
            for (String string2 : this.testMethods) {
                if (string.startsWith(string2 + "(\"")) {
                    this.handleLineWithStartingTestMethodWithInformationOnSameLine(string, string2);
                    continue;
                }
                if (!string.equals(string2 + "(")) continue;
                this.lastLineContainedOpeningTestMethodWithoutQuotedString = true;
            }
        }
    }

    private String removeAllowedLineEndingsForStandAlone(String string) {
        return this.removeAllowedLineEndings(string, ALLOWED_LINE_ENDINGS_STAND_ALONE);
    }

    private String removeAllowedLineEndings(String string) {
        return this.removeAllowedLineEndings(string, ALLOWED_LINE_ENDINGS);
    }

    private String removeAllowedLineEndings(String string, List<String> list) {
        String string2 = string;
        for (String string3 : list) {
            string2 = Text.removeTextAtEndIfEndsWith(string2, string3);
        }
        return string2;
    }

    private void handleLineWithStartingTestMethodWithInformationOnSameLine(String string, String string2) {
        int n;
        String string3 = string2 + "(";
        String string4 = Text.removeTextAtFrontIfStartsWith(string, string3);
        if (string4.length() == string.length()) {
            throw new RuntimeException("Zeile begann nicht mit der erwarteten Zeichenfolge.\n\tBereinigte Zeile       : " + string + "\n\tErwarteter Zeilenanfang: " + string3 + "\n");
        }
        int n2 = string4.length();
        if (n2 == (n = (string4 = this.removeAllowedLineEndings(string4)).length())) {
            throw new RuntimeException("Zeile hat unerwartetes Ende.\n\tBereinigte Zeile       : " + string + "\n");
        }
        this.extractInformationFrom(string4);
    }

    protected abstract void extractInformationFrom(String var1);

    protected void addInformation(String string) {
        if (this.informations.contains(string)) {
            System.out.println("Der Test von\n\t" + string + "\nkommt mehrfach vor!");
        } else {
            this.informations.add(string);
        }
    }

    protected List<String> getInformations() {
        return this.informations;
    }
}

