/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.test;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import java.io.File;
import java.net.URL;
import java.util.List;

public class TestHelper {
    private final String testDataPath;
    private final Class<?> testClass;
    private final int levelsAboveProjectDirectory;
    private final String className;
    private final String projectDirectory;
    private final List<String> subDirectoriesFromProjectBaseToTestfiles;

    public TestHelper(Class<?> clazz, int n, List<String> list) {
        this.testClass = clazz;
        this.levelsAboveProjectDirectory = n;
        this.subDirectoriesFromProjectBaseToTestfiles = list;
        this.className = this.determinePureClassName();
        this.projectDirectory = this.determineProjectDirectory();
        this.testDataPath = this.determineTestDataPath();
    }

    private String determinePureClassName() {
        String string = this.testClass.getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    private String determineProjectDirectory() {
        URL uRL = this.testClass.getResource(this.className + ".class");
        File file = new File(uRL.getPath());
        for (int i = 0; i < this.levelsAboveProjectDirectory; ++i) {
            file = new File(file.getParent());
        }
        return file.getPath();
    }

    private String determineTestDataPath() {
        String string = this.projectDirectory;
        for (String string2 : this.subDirectoriesFromProjectBaseToTestfiles) {
            string = FileHelper.concatPathes(string, string2);
        }
        return string;
    }

    public String getClassName() {
        return this.className;
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public String getTestDataPath() {
        return this.testDataPath;
    }

    public String getTestFile(String string) {
        return FileHelper.concatPathes(this.testDataPath, string);
    }

    public String getTestDir(String string) {
        return this.getTestFile(string);
    }

    public String getTestFileInSubDir(String string, String string2) {
        return FileHelper.concatPathesMultiple(this.testDataPath, string, string2);
    }

    public static TestHelper createForTestData(Class<?> clazz, int n) {
        return new TestHelper(clazz, n, CollectionsHelper.buildListFrom("test", "data"));
    }

    public static TestHelper createForBasics(Class<?> clazz, int n) {
        return new TestHelper(clazz, n, CollectionsHelper.buildListFrom("data", "testfiles"));
    }
}

