/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.data;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;

public class FreeSpaceInfo {
    private final long totalDiscSpace;
    private final long freeDiscSpace;
    private final long totalDiscSpaceKb;
    private final long freeDiscSpaceKb;
    private final long totalDiscSpaceMb;
    private final long freeDiscSpaceMb;
    private final long totalDiscSpaceGb;
    private final long freeDiscSpaceGb;
    private final double percentFree;
    private final String percentFreeDescription;

    public FreeSpaceInfo(String string) {
        this.totalDiscSpace = FileHelper.totalDiscSpace(string);
        this.freeDiscSpace = FileHelper.freeDiscSpace(string);
        this.totalDiscSpaceKb = this.totalDiscSpace / 1024L;
        this.freeDiscSpaceKb = this.freeDiscSpace / 1024L;
        this.totalDiscSpaceMb = this.totalDiscSpaceKb / 1024L;
        this.freeDiscSpaceMb = this.freeDiscSpaceKb / 1024L;
        this.totalDiscSpaceGb = this.totalDiscSpaceMb / 1024L;
        this.freeDiscSpaceGb = this.freeDiscSpaceMb / 1024L;
        this.percentFree = NumberString.percentAsNumber(this.freeDiscSpace, this.totalDiscSpace);
        this.percentFreeDescription = NumberString.twoDecimalPlaces(this.percentFree);
    }

    public long getTotalDiscSpace() {
        return this.totalDiscSpace;
    }

    public long getFreeDiscSpace() {
        return this.freeDiscSpace;
    }

    public long getTotalDiscSpaceKb() {
        return this.totalDiscSpaceKb;
    }

    public long getFreeDiscSpaceKb() {
        return this.freeDiscSpaceKb;
    }

    public long getTotalDiscSpaceMb() {
        return this.totalDiscSpaceMb;
    }

    public long getFreeDiscSpaceMb() {
        return this.freeDiscSpaceMb;
    }

    public long getTotalDiscSpaceGb() {
        return this.totalDiscSpaceGb;
    }

    public long getFreeDiscSpaceGb() {
        return this.freeDiscSpaceGb;
    }

    public double getPercentFree() {
        return this.percentFree;
    }

    public String getPercentFreeDescription() {
        return this.percentFreeDescription;
    }

    public String totalMb() {
        return Text.fillWithSpacesAtFront(NumberString.taupu(this.totalDiscSpaceMb), 10) + " MB";
    }

    public String freeMb() {
        return Text.fillWithSpacesAtFront(NumberString.taupu(this.freeDiscSpaceMb), 10) + " MB (" + this.percentFreeDescription + "%)";
    }
}

