/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download.logic;

import de.duehl.basics.io.exceptions.IORuntimeException;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.data.DownloadParameters;
import de.duehl.html.download.data.DownloadStatus;
import de.duehl.html.download.data.RedirectHandling;
import de.duehl.html.download.proxy.RotatingProxies;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpGetter {
    private static final String REQUEST_HEADER_ACCEPT_LANGUAGE = "de-de,de;q=0.8,en-us;q=0.5,en;q=0.3";
    private static final String META_REDIRECT_START = "<meta http-equiv=\"refresh\" content=\"";
    private final DownloadParameters parameters;
    private final DownloadInfo downloadInfo;

    public HttpGetter(DownloadParameters downloadParameters, DownloadInfo downloadInfo) {
        this.parameters = downloadParameters;
        this.downloadInfo = downloadInfo;
    }

    public void loadHttpGet(CloseableHttpClient closeableHttpClient) {
        this.log("Start");
        HttpGet httpGet = new HttpGet(this.parameters.getWebsite());
        httpGet.addHeader("Accept-Language", REQUEST_HEADER_ACCEPT_LANGUAGE);
        this.loadHttpGet(closeableHttpClient, httpGet);
        this.log("Ende");
    }

    private void loadHttpGet(CloseableHttpClient closeableHttpClient, HttpGet httpGet) {
        try {
            this.tryToLoadHttpGet(closeableHttpClient, httpGet);
        }
        catch (IOException iOException) {
            this.handleDownloadException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToLoadHttpGet(CloseableHttpClient closeableHttpClient, HttpGet httpGet) throws IOException, ClientProtocolException {
        this.log("Start");
        this.log("response = " + closeableHttpResponse);
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);){
            this.workOnResponse(httpGet, closeableHttpResponse);
        }
    }

    private void workOnResponse(HttpGet httpGet, CloseableHttpResponse closeableHttpResponse) throws HttpResponseException, IOException {
        String string;
        int n = this.getStatusCode(closeableHttpResponse);
        this.log("statusCode = " + n);
        HttpEntity httpEntity = closeableHttpResponse.getEntity();
        String string2 = "";
        if (n == 302 || n == 303) {
            string2 = closeableHttpResponse.getFirstHeader("Location").getValue();
            this.log("Status Code 302 / 303 via Location-Header: " + string2);
            string = "";
        } else if (n == 301 || n == 307) {
            string2 = closeableHttpResponse.getFirstHeader("Location").getValue();
            this.log("Status Code 301 / 307 via Location-Header: " + string2);
            string = "";
        } else if (n == 200) {
            string = this.getHtmlContents(closeableHttpResponse);
            if (this.isRedirectByMetaHeader(string)) {
                this.log("Bei Status Code 200 Redirect \u00fcber meta header im HTML gefunden!");
                string2 = this.getRedirectByMetaHeader(string);
                if (string2.isEmpty()) {
                    this.log("Redirect \u00fcber meta header im HTML - keine Seite gefunden");
                } else {
                    this.log("redirect auf " + string2);
                }
            }
        } else {
            string = this.getHtmlContents(closeableHttpResponse);
        }
        this.log("redirectUrlToFollow = " + string2);
        EntityUtils.consume((HttpEntity)httpEntity);
        String string3 = this.getReturned(httpGet);
        this.log("returnedUrl = " + string3);
        DownloadStatus downloadStatus = DownloadStatus.getFromStatusCode(n);
        this.log("status = " + downloadStatus);
        this.downloadInfo.storeResult(downloadStatus, n, string3, string, string2);
    }

    private boolean isRedirectByMetaHeader(String string) {
        if (string.contains(META_REDIRECT_START)) {
            String string2 = HtmlTool.removeHtmlComments(string);
            return string2.contains(META_REDIRECT_START);
        }
        return false;
    }

    private String getRedirectByMetaHeader(String string) {
        String string2;
        String string3 = "<meta http-equiv=\"refresh\" content=\"\\d+; ?URL ?= ?([^\"]+)\"";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string2 = HtmlTool.removeHtmlComments(string));
        if (matcher.find()) {
            String string4 = matcher.group(1).trim();
            this.log("redirect = " + string4);
            return string4;
        }
        return "";
    }

    private int getStatusCode(CloseableHttpResponse closeableHttpResponse) {
        StatusLine statusLine = closeableHttpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        return n;
    }

    private String getHtmlContents(CloseableHttpResponse closeableHttpResponse) throws HttpResponseException, IOException {
        String string = new BasicResponseHandler().handleResponse((HttpResponse)closeableHttpResponse);
        return string;
    }

    private String getReturned(HttpGet httpGet) {
        RedirectHandling redirectHandling = this.parameters.getRedirectHandling();
        boolean bl = redirectHandling.isRedirectHandledByCaller();
        if (bl) {
            return this.getReturnedUrlForHandledRedirectsByCaller(httpGet);
        }
        return this.getReturnedUrlForDefault(httpGet);
    }

    private String getReturnedUrlForHandledRedirectsByCaller(HttpGet httpGet) {
        URI uRI = httpGet.getURI();
        String string = uRI.toString();
        this.log("returnedUrl = " + string);
        return string;
    }

    private String getReturnedUrlForDefault(HttpGet httpGet) {
        throw new RuntimeException("No solution yet!");
    }

    private void handleDownloadException(IOException iOException) {
        this.log("Download failed");
        this.downloadInfo.failed();
        this.perhapsRotateRotatingProxy(iOException.getMessage());
        throw new IORuntimeException(iOException);
    }

    private void perhapsRotateRotatingProxy(String string) {
        if (null == string) {
            return;
        }
        if (string.contains("Connection Refused") || string.contains("Connection timed out")) {
            this.log("Proxy geblockt?!");
            if (this.parameters.useRotatingProxies()) {
                RotatingProxies rotatingProxies = this.parameters.getRotatingProxies();
                rotatingProxies.switchProxy();
                this.log("Schalte rotierenden Proxy weiter auf " + rotatingProxies.getProxy());
            }
        }
    }

    private void log(String string) {
        if (this.parameters.weHaveALogger()) {
            Logger logger = this.parameters.getLogger();
            logger.log(string, 1);
        }
    }
}

