/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.persistance;

import de.duehl.swing.ui.GuiTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorOptionUi {
    private final String title;
    private Color color;
    private final JPanel panel;
    private final JLabel titleLabel;

    public ColorOptionUi(String string) {
        this(string, Color.BLACK);
    }

    public ColorOptionUi(String string, Color color) {
        this.title = string;
        this.color = color;
        this.panel = new JPanel();
        this.titleLabel = new JLabel(string);
        this.init();
        this.createUi();
    }

    private void init() {
        GuiTools.biggerFont(this.titleLabel, 5);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(Color.WHITE);
        this.titleLabel.setHorizontalAlignment(0);
        this.actualiseColors();
    }

    private void createUi() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.titleLabel, "Center");
        this.panel.add(this.createColorChangeButton(), "East");
    }

    private Component createColorChangeButton() {
        JButton jButton = new JButton("Farbe \u00e4ndern");
        jButton.addActionListener(actionEvent -> this.changeColor());
        return jButton;
    }

    private void changeColor() {
        Color color = JColorChooser.showDialog(this.panel, this.title + " festlegen", this.color);
        if (null != color) {
            this.setColor(color);
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.actualiseColors();
    }

    private void actualiseColors() {
        this.colorTitleLabel();
    }

    private void colorTitleLabel() {
        this.titleLabel.setForeground(this.color);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public Color getColor() {
        return this.color;
    }
}

