/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons.vertical;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class VerticalButtonUI
extends BasicButtonUI {
    protected int angle;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public VerticalButtonUI(int n) {
        this.angle = n;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JButton jButton = (JButton)jComponent;
        String string = jButton.getText();
        Icon icon2 = icon = jButton.isEnabled() ? jButton.getIcon() : jButton.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        paintViewInsets = jComponent.getInsets(paintViewInsets);
        VerticalButtonUI.paintViewR.x = VerticalButtonUI.paintViewInsets.left;
        VerticalButtonUI.paintViewR.y = VerticalButtonUI.paintViewInsets.top;
        VerticalButtonUI.paintViewR.height = jComponent.getWidth() - (VerticalButtonUI.paintViewInsets.left + VerticalButtonUI.paintViewInsets.right);
        VerticalButtonUI.paintViewR.width = jComponent.getHeight() - (VerticalButtonUI.paintViewInsets.top + VerticalButtonUI.paintViewInsets.bottom);
        VerticalButtonUI.paintIconR.height = 0;
        VerticalButtonUI.paintIconR.width = 0;
        VerticalButtonUI.paintIconR.y = 0;
        VerticalButtonUI.paintIconR.x = 0;
        VerticalButtonUI.paintTextR.height = 0;
        VerticalButtonUI.paintTextR.width = 0;
        VerticalButtonUI.paintTextR.y = 0;
        VerticalButtonUI.paintTextR.x = 0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.angle == 90) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -jComponent.getWidth());
            VerticalButtonUI.paintViewR.x = jComponent.getHeight() / 2 - (int)fontMetrics.getStringBounds(string, graphics).getWidth() / 2;
            VerticalButtonUI.paintViewR.y = jComponent.getWidth() / 2 - (int)fontMetrics.getStringBounds(string, graphics).getHeight() / 2;
        } else if (this.angle == 270) {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-jComponent.getHeight(), 0);
            VerticalButtonUI.paintViewR.x = jComponent.getHeight() / 2 - (int)fontMetrics.getStringBounds(string, graphics).getWidth() / 2;
            VerticalButtonUI.paintViewR.y = jComponent.getWidth() / 2 - (int)fontMetrics.getStringBounds(string, graphics).getHeight() / 2;
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, VerticalButtonUI.paintIconR.x, VerticalButtonUI.paintIconR.y);
        }
        if (string != null) {
            int n = VerticalButtonUI.paintTextR.x;
            int n2 = VerticalButtonUI.paintTextR.y + fontMetrics.getAscent();
            if (jButton.isEnabled()) {
                this.paintText(graphics, jComponent, new Rectangle(VerticalButtonUI.paintViewR.x, VerticalButtonUI.paintViewR.y, n, n2), string);
            } else {
                this.paintText(graphics, jComponent, new Rectangle(VerticalButtonUI.paintViewR.x, VerticalButtonUI.paintViewR.y, n, n2), string);
            }
        }
        graphics2D.setTransform(affineTransform);
    }
}

