/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.colors;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.colors.NamedColorList;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import de.duehl.swing.ui.colors.UnknownColorException;
import java.awt.Color;

public class ColorTranslator {
    private final NamedColorList namedColors = new NamedColorListFabric().genrateColorList();

    public static Color hex2Swing(String string) {
        int n;
        if (string.length() != 6) {
            throw new UnknownColorException("Der Farbwert der hexColor muss sechs Zeichen lang sein. Zum Beispiel \"FF0000\"! hexColor = '" + string + "'");
        }
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownColorException("Der Wert der hexColor konnte nicht zur Basis 16 in eine Integerzahl geparst werden. hexColor = " + string);
        }
        Color color = new Color(n);
        return color;
    }

    public static String swing2Hex(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        String string = String.format("%02X", n);
        String string2 = String.format("%02X", n2);
        String string3 = String.format("%02X", n3);
        String string4 = string + string2 + string3;
        return string4;
    }

    public Color getColorByName(String string) {
        return this.namedColors.getColorByName(string);
    }

    public String getHexCodeByName(String string) {
        return this.namedColors.getHexCodeFromNamedColorByName(string);
    }

    public Color nameOrHex2Swing(String string) {
        if (string.length() == 6 && string.matches("[A-Fa-f0-9]{6}")) {
            return ColorTranslator.hex2Swing(string);
        }
        return this.getColorByName(string);
    }

    public static String rgbToHexColor(int n, int n2, int n3) {
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("Parameter au\u00dferhalb des erlaubtenm Bereichs [0, 255]\n\tred   = " + n + "\n\tgreen = " + n2 + "\n\tblue  = " + n3 + "\n");
        }
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        string = NumberString.addLeadingZeroes(string, 2);
        string2 = NumberString.addLeadingZeroes(string2, 2);
        string3 = NumberString.addLeadingZeroes(string3, 2);
        return string + string2 + string3;
    }
}

