/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.elements.TextFieldWithChangeButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TextFieldWithChangeButtonAndTitle {
    private final JLabel titleLabel;
    private final TextFieldWithChangeButton fieldWithButton;
    private final Component panel;

    public TextFieldWithChangeButtonAndTitle(String string) {
        this.titleLabel = new JLabel(string);
        this.fieldWithButton = new TextFieldWithChangeButton();
        this.panel = this.createPanel();
    }

    private Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "North");
        jPanel.add(this.fieldWithButton.getPanel(), "Center");
        return jPanel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.panel);
        colorizer.setColors(this.titleLabel);
        this.fieldWithButton.colorize(colorizer);
    }

    public void addButtonActionListener(ActionListener actionListener) {
        this.fieldWithButton.addButtonActionListener(actionListener);
    }

    public String getText() {
        return this.fieldWithButton.getText();
    }

    public void setText(String string) {
        this.fieldWithButton.setText(string);
    }

    public void setButtonText(String string) {
        this.fieldWithButton.setButtonText(string);
    }

    public void setPreferredSize(Dimension dimension) {
        this.fieldWithButton.setPreferredSize(dimension);
    }

    public void setButtonPreferredSize(Dimension dimension) {
        this.fieldWithButton.setButtonPreferredSize(dimension);
    }

    public void clickButton() {
        this.fieldWithButton.clickButton();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.fieldWithButton.addKeyListener(keyListener);
    }

    public void addReturnKeyClickButtonListener() {
        this.fieldWithButton.addReturnKeyClickButtonListener();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fieldWithButton.addFocusListener(focusListener);
    }

    public void addTextFieldActionListener(ActionListener actionListener) {
        this.fieldWithButton.addTextFieldActionListener(actionListener);
    }

    public void setToolTipText(String string) {
        this.titleLabel.setToolTipText(string);
        this.fieldWithButton.setToolTipText(string);
    }

    public void requestFocus() {
        this.fieldWithButton.requestFocus();
    }

    public void requestFocusLater() {
        SwingUtilities.invokeLater(() -> this.requestFocus());
    }
}

