/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitledList {
    private final JLabel titleLabel;
    private final List<String> valueList;
    private final List<JLabel> valueLabelList;
    private final JPanel panel;
    private final JPanel listPanel;

    public TitledList(String string) {
        this(string, new ArrayList<String>());
    }

    public TitledList(String string, List<String> list) {
        this.valueList = list;
        this.titleLabel = new JLabel(string);
        this.valueLabelList = new ArrayList<JLabel>();
        this.fillValueLabelList();
        this.panel = new JPanel();
        this.listPanel = new JPanel();
        this.populatePanel();
    }

    private void fillValueLabelList() {
        for (String string : this.valueList) {
            JLabel jLabel = new JLabel(string);
            this.valueLabelList.add(jLabel);
        }
    }

    private void populatePanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.titleLabel, "North");
        this.panel.add(this.createListPanel(), "Center");
    }

    private Component createListPanel() {
        this.listPanel.setLayout(new VerticalLayout(2, 3));
        GuiTools.createTitle(this.listPanel);
        for (JLabel jLabel : this.valueLabelList) {
            this.listPanel.add(jLabel);
        }
        return this.listPanel;
    }

    public void addValueToList(String string) {
        this.valueList.add(string);
        JLabel jLabel = new JLabel(string);
        this.valueLabelList.add(jLabel);
        this.listPanel.add(jLabel);
        this.listPanel.validate();
    }

    public void setPreferredTitleSize(Dimension dimension) {
        this.titleLabel.setPreferredSize(dimension);
    }

    public void setTitleColor(Color color) {
        this.titleLabel.setForeground(color);
    }

    public void useMonospacedFontForTheTitle() {
        GuiTools.setMonospacedFont(this.titleLabel);
    }

    public void addToTitleSize(int n) {
        GuiTools.biggerFont(this.titleLabel, n);
    }

    public void setPreferredListElementSize(Dimension dimension) {
        for (JLabel jLabel : this.valueLabelList) {
            jLabel.setPreferredSize(dimension);
        }
    }

    public void setListColor(Color color) {
        for (JLabel jLabel : this.valueLabelList) {
            jLabel.setForeground(color);
        }
    }

    public void useMonospacedFontForTheList() {
        for (JLabel jLabel : this.valueLabelList) {
            GuiTools.setMonospacedFont(jLabel);
        }
    }

    public Component getPanel() {
        return this.panel;
    }
}

