/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.creator.ButtonCreator;
import de.duehl.swing.ui.buttons.creator.StandardButtonCreator;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class VerticalTabulator {
    private final JPanel buttonPanel = new JPanel();
    private final JPanel contentPanel = new JPanel();
    private final CardLayout cardLayout;
    private final List<String> buttonTexts;
    private ButtonCreator buttonCreator;

    public VerticalTabulator() {
        this.buttonPanel.setLayout(new VerticalLayout(5, 3));
        this.cardLayout = new CardLayout();
        this.contentPanel.setLayout(this.cardLayout);
        this.buttonTexts = new ArrayList<String>();
        this.buttonCreator = new StandardButtonCreator();
    }

    public void setButtonCreator(ButtonCreator buttonCreator) {
        this.buttonCreator = buttonCreator;
    }

    public void addTabulator(String string, Component component) {
        if (this.buttonTexts.contains(string)) {
            throw new IllegalArgumentException("Doppelte Button-Beschriftung: '" + string + "'!");
        }
        this.buttonTexts.add(string);
        this.contentPanel.add(component, string);
        this.buttonPanel.add(this.createButton(string));
    }

    private Component createButton(String string) {
        return this.buttonCreator.createButton(string, () -> this.switchToTabulator(string));
    }

    private void switchToTabulator(String string) {
        this.cardLayout.show(this.contentPanel, string);
    }

    public Component createPanelWithButtonsOnTheLeft() {
        this.showFirstTabulator();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buttonPanel, "West");
        jPanel.add((Component)this.contentPanel, "Center");
        return jPanel;
    }

    private void showFirstTabulator() {
        if (this.buttonTexts.isEmpty()) {
            throw new RuntimeException("Es wurden vergessen, mit addTabluator() Tabulatoren zum VerticalTabulator hinzuzuf\u00fcgen!");
        }
        this.switchToTabulator(this.buttonTexts.get(0));
    }

    public void createBorders() {
        this.createButtonsBorder();
        this.createContentBorder();
    }

    public void createButtonsBorder() {
        GuiTools.createTitle(this.buttonPanel);
    }

    public void createContentBorder() {
        GuiTools.createTitle(this.contentPanel);
    }
}

