/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.basics.text.Separator;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SeparatorSelection {
    private static final int VERTICAL_SPACE = 2;
    private ButtonGroup group = new ButtonGroup();
    private List<JRadioButton> separatorButtons = new ArrayList<JRadioButton>();
    private JPanel panel;

    public SeparatorSelection(String string) {
        for (Separator separator : Separator.values()) {
            this.separatorButtons.add(new JRadioButton(separator.name()));
        }
        this.select(Separator.TABULATOR);
        this.panel = new JPanel();
        this.panel.setLayout(new VerticalLayout(2, 3));
        GuiTools.createTitle(string, this.panel);
        this.addToGroup();
        this.addToPanel();
    }

    private void addToGroup() {
        for (JRadioButton jRadioButton : this.separatorButtons) {
            this.group.add(jRadioButton);
        }
    }

    private void addToPanel() {
        for (JRadioButton jRadioButton : this.separatorButtons) {
            this.panel.add(jRadioButton);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void select(Separator separator) {
        String string = separator.name();
        for (JRadioButton jRadioButton : this.separatorButtons) {
            String string2 = jRadioButton.getText();
            jRadioButton.setSelected(string2.equals(string));
        }
    }

    public Separator getSelected() {
        for (JRadioButton jRadioButton : this.separatorButtons) {
            if (!jRadioButton.isSelected()) continue;
            String string = jRadioButton.getText();
            return Separator.detectFromNameString(string);
        }
        throw new RuntimeException("Kein Button ausgew\u00e4hlt.");
    }

    public void setToolTipText(String string) {
        this.panel.setToolTipText(string);
        for (JRadioButton jRadioButton : this.separatorButtons) {
            jRadioButton.setToolTipText(string);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        for (JRadioButton jRadioButton : this.separatorButtons) {
            jRadioButton.addActionListener(actionListener);
        }
    }
}

