/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections.base;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.elements.TextFieldWithChangeButtonAndOption;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class OptionalFileOrPathSelection {
    private final TextFieldWithChangeButtonAndOption elements;

    public OptionalFileOrPathSelection(String string) {
        this.elements = new TextFieldWithChangeButtonAndOption(string);
        this.elements.addButtonActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionalFileOrPathSelection.this.changeDirectory();
            }
        };
    }

    private void changeDirectory() {
        String string = this.openPath(this.elements.getText());
        if (!string.isEmpty()) {
            this.elements.setText(Text.nicePath(string));
        }
    }

    protected abstract String openPath(String var1);

    public boolean isSelected() {
        return this.elements.isSelected();
    }

    public void setSelected(boolean bl) {
        this.elements.setSelected(bl);
    }

    public Component getPanel() {
        return this.elements.getPanel();
    }

    public void colorize(Colorizer colorizer) {
        this.elements.colorize(colorizer);
    }

    public String getText() {
        return this.elements.getText();
    }

    public void setText(String string) {
        this.elements.setText(string);
    }

    public void setPreferredSize(Dimension dimension) {
        this.elements.setPreferredSize(dimension);
    }
}

