/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.values;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EnterLongTextDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 300);
    private final JTextArea valueArea;
    private final String question;
    private final String presetting;

    public EnterLongTextDialog(Point point, Image image, String string, String string2, String string3) {
        this(null, point, image, string, string2, string3);
    }

    public EnterLongTextDialog(Colorizer colorizer, Point point, Image image, String string, String string2, String string3) {
        super(point, image, string, DIALOG_DIMENSION, colorizer);
        this.question = string2;
        this.presetting = string3;
        this.valueArea = new JTextArea();
        this.fillDialog();
        this.addClosingWindowListener(() -> this.escape());
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createQuestionPart(), "North");
        this.add(this.createEnterValuePart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.setKeyBindings();
    }

    private void initElements() {
        this.setColors(this.valueArea);
        this.valueArea.setCaretColor(Color.RED);
        this.valueArea.setLineWrap(true);
        this.valueArea.setWrapStyleWord(true);
        GuiTools.biggerFont(this.valueArea, 5);
        this.valueArea.setText(this.presetting);
        this.valueArea.selectAll();
    }

    private Component createQuestionPart() {
        JLabel jLabel = new JLabel(this.question);
        this.setColors(jLabel);
        return jLabel;
    }

    private Component createEnterValuePart() {
        return new JScrollPane(this.valueArea, 20, 31);
    }

    private void setKeyBindings() {
        this.setKeyBindingEscape(() -> this.escape());
    }

    private void escape() {
        this.valueArea.setText("");
        this.closeDialog();
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createQuitButton(), "West");
        jPanel.add((Component)this.createOkButton(), "East");
        return jPanel;
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.escape());
        return jButton;
    }

    private JButton createOkButton() {
        JButton jButton = new JButton("OK");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    public String getEnteredValue() {
        return this.valueArea.getText().trim();
    }
}

